/*
 * Decompiled with CFR 0.152.
 */
package popometer.bikeandfit;

import popometer.bikeandfit.Einstellrad;
import popometer.bikeandfit.Koerpermasse;
import popometer.bikeandfit.Parameter;
import popometer.math.Polygonzug;
import projektY.base.YException;
import projektY.base.YUserException;

public class MagischesDreieck {
    private Parameter parameter;
    private double oben;
    private double hinten;
    private double vorn;
    private double neigungswinkel;
    private double rahmenwinkel;
    private Winkelsatz[] winkelsaetze;
    Polygonzug.Punkt K;
    Polygonzug.Punkt L;
    Polygonzug.Punkt S;

    public MagischesDreieck(Parameter parameter) {
        this.parameter = parameter;
        this.winkelsaetze = new Winkelsatz[]{new Winkelsatz(1, "aufrecht", 100.0, 50.0, 168.0, 108.0, 179.0), new Winkelsatz(2, "leicht gebeugt", 115.0, 75.0, 175.0, 108.0, 179.0), new Winkelsatz(3, "moderat", 122.0, 85.0, 175.0, 108.0, 179.0), new Winkelsatz(4, "gestaucht", 122.0, 70.0, 165.0, 108.0, 179.0), new Winkelsatz(5, "downhill", 103.0, 70.0, 172.0, 123.0, 142.0), new Winkelsatz(6, "gestreckt", 136.0, 90.0, 178.0, 108.0, 179.0), new Winkelsatz(7, "Triathlon", 157.0, 68.0, 90.0, 100.0, 179.0)};
        this.K = new Polygonzug.Punkt();
        this.L = new Polygonzug.Punkt();
        this.S = new Polygonzug.Punkt();
        this.oben = 0.0;
        this.hinten = 0.0;
        this.vorn = 0.0;
        this.neigungswinkel = 0.0;
        this.rahmenwinkel = 0.0;
    }

    public void set(double oben, double hinten, double vorn, double neigungswinkel) throws YUserException {
        System.out.format("MagDreieck.set: oben=%5.1f hinten=%5.1f vorn=%5.1f neigungswinkel=%5.1f\n", oben, hinten, vorn, neigungswinkel);
        this.oben = oben;
        this.hinten = hinten;
        this.vorn = vorn;
        this.neigungswinkel = neigungswinkel;
        this.S.x = 0.0;
        this.S.y = 0.0;
        this.S.a = 0.0;
        this.L.x = Math.cos(Polygonzug.VektorSumme.degToRad(neigungswinkel)) * oben;
        this.L.y = Math.sin(Polygonzug.VektorSumme.degToRad(neigungswinkel)) * oben;
        this.L.a = oben;
        this.K.a = hinten;
        double p = hinten * hinten;
        double a = 2.0 * this.L.x;
        double b = 2.0 * this.L.y;
        double q = this.L.x * this.L.x + this.L.y * this.L.y + hinten * hinten - vorn * vorn;
        System.out.format("Zwischenergebnis 1: p=%5.1f a=%5.1f b=%5.1f q=%5.1f\n", p, a, b, q);
        double A = -(b * b) / (a * a) + 1.0;
        double B = -(2.0 * q * b) / (a * a);
        double C = q * q / (a * a) - p;
        System.out.format("Zwischenergebnis 2: A=%5.1f B=%5.1f C=%5.1f\n", A, B, C);
        A = 1.0;
        double D = (B /= A) / 2.0 * (B / 2.0) - (C /= A);
        System.out.format("Zwischenergebnis 3: A=%5.1f B=%5.1f C=%5.1f D=%5.1f\n", A, B, C, D);
        if (!(D >= 0.0)) {
            throw new YUserException("Ung\u00fcltiges Magisches Dreieck.\nKoordinaten k\u00f6nnen nicht berechnet werden.");
        }
        double y1 = -(B / 2.0) + Math.sqrt(D);
        double y2 = -(B / 2.0) - Math.sqrt(D);
        System.out.format("y1=%5.1f y2=%5.1f\n", y1, y2);
        this.K.y = y1 < this.L.y ? y1 : y2;
        this.K.x = (q - b * this.K.y) / a;
        System.out.format("MagDreieckskoordinaten: K(%2.1f,%2.1f) S(%2.1f,%2.1f) L(%2.1f,%2.1f)\n", this.K.x, this.K.y, this.S.x, this.S.y, this.L.x, this.L.y);
    }

    public void berechnen(int winkelsatzId, Koerpermasse koerpermasse) throws YException {
        Winkelsatz winkelsatz = null;
        for (Winkelsatz ws : this.winkelsaetze) {
            if (ws.id != winkelsatzId) continue;
            winkelsatz = ws;
            break;
        }
        if (winkelsatz == null) {
            throw new YException("Ung\u00fcltige winkelsatzId: " + winkelsatzId);
        }
        Polygonzug pzOK = new Polygonzug();
        Polygonzug pzBein = new Polygonzug();
        pzOK.append(winkelsatz.rw, false, koerpermasse.ok);
        pzOK.append(winkelsatz.sw, true, koerpermasse.oa);
        pzOK.append(winkelsatz.ew, false, koerpermasse.ua);
        pzBein.append(winkelsatz.bw, true, koerpermasse.os);
        pzBein.append(winkelsatz.kw, true, koerpermasse.usf);
        pzBein.endPunkt(this.K);
        pzOK.endPunkt(this.L);
        this.S.x = -koerpermasse.vxHK;
        this.S.y = -koerpermasse.vyHK;
        double f = (this.K.a - (double)this.parameter.kurbellaenge) / this.K.a;
        this.K.x *= f;
        this.K.y *= f;
        this.K.a -= (double)this.parameter.kurbellaenge;
        System.out.format("Winkelsatz: rw=%2.1f sw=%2.1f ew=%2.1f bw=%2.1f kw=%2.1f\n", winkelsatz.rw, winkelsatz.sw, winkelsatz.ew, winkelsatz.bw, winkelsatz.kw);
        System.out.format("MagDreieckskoordinaten: K(%2.1f,%2.1f) S(%2.1f,%2.1f) L(%2.1f,%2.1f)\n", this.K.x, this.K.y, this.S.x, this.S.y, this.L.x, this.L.y);
        System.out.format("     ... transformiert: K(%2.1f,%2.1f) S(%2.1f,%2.1f) L(%2.1f,%2.1f)\n", this.K.x - this.S.x, this.K.y - this.S.y, Float.valueOf(0.0f), Float.valueOf(0.0f), this.L.x - this.S.x, this.L.y - this.S.y);
        System.out.format("Versatz H\u00fcfte-Sitzknochen dX=%2.1f dY=%2.1f\n", Float.valueOf(koerpermasse.vxHK), Float.valueOf(koerpermasse.vyHK));
        this.oben = this.L.abstand(this.S);
        this.hinten = this.S.abstand(this.K);
        this.vorn = this.K.abstand(this.L);
        this.neigungswinkel = Polygonzug.VektorSumme.radToDeg(Math.asin((this.L.y - this.S.y) / this.L.abstand(this.S)));
        System.out.format("MagDreieck.berechnet: oben=%5.1f hinten=%5.1f vorn=%5.1f neigungswinkel=%5.1f\n", this.oben, this.hinten, this.vorn, this.neigungswinkel);
        Polygonzug.Punkt M = new Polygonzug.Punkt();
        M.x = this.parameter.blickrichtungRechts ? this.S.x - (double)this.parameter.abstandSitzknochenposition : this.S.x + (double)this.parameter.abstandSitzknochenposition;
        M.y = this.S.y;
        this.rahmenwinkel = 90.0 - Polygonzug.VektorSumme.radToDeg(Math.asin((this.K.x - M.x) / this.K.abstand(M)));
        System.out.format("Rahmenwinkel roh=%2.1f korrigiert=%2.2f\n", 90.0 - Polygonzug.VektorSumme.radToDeg(Math.asin((this.K.x - this.S.x) / this.K.abstand(this.S))), this.rahmenwinkel);
    }

    public void berechnen(Einstellrad einstellrad) {
        this.S.x = -Math.cos(einstellrad.getRwRad()) * einstellrad.getSitzhoehe() - (double)this.parameter.abstandSitzknochenposition - einstellrad.getSitzversatz();
        this.S.y = Math.sin(einstellrad.getRwRad()) * einstellrad.getSitzhoehe();
        this.L.x = (double)this.parameter.abstandLenksaeule + einstellrad.getLenkerversatz();
        this.L.y = einstellrad.getLenkerhoehe();
        this.K.x = 0.0;
        this.K.y = 0.0;
        this.hinten = this.S.abstand(this.K);
        this.vorn = this.L.abstand(this.K);
        this.oben = this.S.abstand(this.L);
        this.neigungswinkel = Polygonzug.VektorSumme.radToDeg(Math.asin((this.L.y - this.S.y) / this.L.abstand(this.S)));
        Polygonzug.Punkt M = new Polygonzug.Punkt();
        M.x = this.S.x + (double)this.parameter.abstandSitzknochenposition;
        M.y = this.S.y;
        this.rahmenwinkel = Polygonzug.VektorSumme.radToDeg(Math.atan(Math.abs(M.y / M.x)));
    }

    public double getOben() {
        return this.oben;
    }

    public double getHinten() {
        return this.hinten;
    }

    public double getVorn() {
        return this.vorn;
    }

    public double getNeigungswinkel() {
        return this.neigungswinkel;
    }

    public double getRahmenwinkel() {
        return this.rahmenwinkel;
    }

    public String toString() {
        return String.format("A%s B%s C%s: oben=%2.1f hinten=%2.1f vorn=%2.1f neigungswinkel=%2.1f rahmenwinkel=%2.1f", this.K.toString(), this.L.toString(), this.S.toString(), this.oben, this.hinten, this.vorn, this.neigungswinkel, this.rahmenwinkel);
    }

    public static class Winkelsatz {
        private int id;
        private String name;
        private double rw;
        private double sw;
        private double ew;
        private double bw;
        private double kw;

        public Winkelsatz(int id, String name, double rw, double sw, double ew, double bw, double kw) {
            this.id = id;
            this.name = name;
            this.rw = rw;
            this.sw = sw;
            this.ew = ew;
            this.bw = bw;
            this.kw = kw;
        }
    }
}

