/*
 * Decompiled with CFR 0.152.
 */
package popometer.forms;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import popometer.panels.PanFotoImage;
import projektY.swing.Utils;

public class DlgFotos
extends JDialog {
    public static final int nImages = 3;
    private PanFotoImage[] fotoImagePanels;
    private Runtime rt;
    private String fotoCmd;
    private File fotoImageFile;
    private StringBuffer errmsg;
    private boolean bilderSchiessen;
    private JButton cmdAbbruch;
    private JButton cmdEndlos;
    private JButton cmdNochmal;
    private JButton cmdOk;
    private JButton cmdSerie;
    private JButton cmdStop;
    private JPanel jPanel2;
    private JPanel panBilder;
    private JPanel panControl;

    public DlgFotos(Frame parent, String fotoCmd, File fotoImageFile) {
        super(parent, true);
        this.initComponents();
        this.fotoCmd = fotoCmd;
        this.fotoImageFile = fotoImageFile;
        this.bilderSchiessen = false;
        this.rt = Runtime.getRuntime();
        this.fotoImagePanels = new PanFotoImage[3];
        for (int i = 0; i < 3; ++i) {
            this.fotoImagePanels[i] = new PanFotoImage();
            this.fotoImagePanels[i].setPreferredSize(new Dimension(380, 360));
            this.fotoImagePanels[i].setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), 8));
            if (i == 0) {
                this.fotoImagePanels[0].setSelected(true);
            }
            this.fotoImagePanels[i].addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (evt.getButton() != 1) {
                        return;
                    }
                    DlgFotos.this.setSelected(evt.getSource());
                }
            });
            this.panBilder.add(this.fotoImagePanels[i]);
        }
        this.pack();
        this.errmsg = new StringBuffer(80);
        Utils.centerWindow((Window)this);
    }

    private boolean bildSchiessen() {
        try {
            String line;
            Process proc = this.rt.exec(this.fotoCmd);
            BufferedReader procerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            this.errmsg.setLength(0);
            proc.waitFor();
            if (proc.exitValue() == 0) {
                Image image = Toolkit.getDefaultToolkit().createImage(this.fotoImageFile.getAbsolutePath());
                for (int i = 2; i > 0; --i) {
                    if (!this.fotoImagePanels[i - 1].hasImage()) continue;
                    this.fotoImagePanels[i].setImage(this.fotoImagePanels[i - 1].getImage());
                }
                this.fotoImagePanels[0].setImage(image);
                return true;
            }
            while ((line = procerr.readLine()) != null) {
                this.errmsg.append(line + "\n");
            }
            Object image = null;
            return false;
        }
        catch (Exception e) {
            this.errmsg.append(e.toString());
            return false;
        }
    }

    private void setSelected(Object panFotoImage) {
        if (!(panFotoImage instanceof PanFotoImage)) {
            return;
        }
        PanFotoImage p = (PanFotoImage)panFotoImage;
        if (p.getImage() == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            this.fotoImagePanels[i].setSelected(this.fotoImagePanels[i] == p);
        }
    }

    public Image execute(boolean serie) {
        if (serie) {
            FotoThread fotoThread = new FotoThread(3);
            fotoThread.start();
        }
        this.setVisible(true);
        for (int i = 0; i < 3; ++i) {
            if (!this.fotoImagePanels[i].isSelected()) continue;
            return this.fotoImagePanels[i].getImage();
        }
        return null;
    }

    private void initComponents() {
        this.panBilder = new JPanel();
        this.panControl = new JPanel();
        this.cmdSerie = new JButton();
        this.cmdNochmal = new JButton();
        this.cmdEndlos = new JButton();
        this.cmdStop = new JButton();
        this.jPanel2 = new JPanel();
        this.cmdAbbruch = new JButton();
        this.cmdOk = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Foto schiessen");
        this.panBilder.setBorder(BorderFactory.createEmptyBorder(8, 0, 4, 0));
        this.panBilder.setLayout(new GridLayout(1, 0, 2, 2));
        this.getContentPane().add((Component)this.panBilder, "Center");
        this.panControl.setBorder(BorderFactory.createEmptyBorder(8, 20, 8, 20));
        this.panControl.setLayout(new GridBagLayout());
        this.cmdSerie.setText("Neue Serie");
        this.cmdSerie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgFotos.this.cmdSerieActionPerformed(evt);
            }
        });
        this.panControl.add((Component)this.cmdSerie, new GridBagConstraints());
        this.cmdNochmal.setText("Weiteres Foto");
        this.cmdNochmal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgFotos.this.cmdNochmalActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.panControl.add((Component)this.cmdNochmal, gridBagConstraints);
        this.cmdEndlos.setText("Endlosschleife");
        this.cmdEndlos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgFotos.this.cmdEndlosActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.panControl.add((Component)this.cmdEndlos, gridBagConstraints);
        this.cmdStop.setText("Stopp");
        this.cmdStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgFotos.this.cmdStopActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.panControl.add((Component)this.cmdStop, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.panControl.add((Component)this.jPanel2, gridBagConstraints);
        this.cmdAbbruch.setText("Abbruch");
        this.cmdAbbruch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgFotos.this.cmdAbbruchActionPerformed(evt);
            }
        });
        this.panControl.add((Component)this.cmdAbbruch, new GridBagConstraints());
        this.cmdOk.setText("O.K.");
        this.cmdOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgFotos.this.cmdOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.panControl.add((Component)this.cmdOk, gridBagConstraints);
        this.getContentPane().add((Component)this.panControl, "South");
    }

    private void cmdNochmalActionPerformed(ActionEvent evt) {
        if (!this.bildSchiessen()) {
            JOptionPane.showMessageDialog(this, this.errmsg.toString(), "Fehler", 0);
            return;
        }
        for (int i = 2; i > 0; --i) {
            this.fotoImagePanels[i].setSelected(false);
        }
        this.fotoImagePanels[0].setSelected(true);
    }

    private void cmdOkActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void cmdAbbruchActionPerformed(ActionEvent evt) {
        for (int i = 0; i < 3; ++i) {
            this.fotoImagePanels[i].setSelected(false);
        }
        this.setVisible(false);
    }

    private void cmdStopActionPerformed(ActionEvent evt) {
        this.bilderSchiessen = false;
    }

    private void cmdSerieActionPerformed(ActionEvent evt) {
        FotoThread fotoThread = new FotoThread(3);
        fotoThread.start();
    }

    private void cmdEndlosActionPerformed(ActionEvent evt) {
        FotoThread fotoThread = new FotoThread(0);
        fotoThread.start();
    }

    private class FotoThread
    extends Thread {
        private int nFotos;
        private int cntFotos;

        public FotoThread(int nFotos) {
            this.nFotos = nFotos;
        }

        @Override
        public void run() {
            DlgFotos.this.cmdOk.setEnabled(false);
            DlgFotos.this.cmdAbbruch.setEnabled(false);
            DlgFotos.this.cmdNochmal.setEnabled(false);
            DlgFotos.this.cmdSerie.setEnabled(false);
            DlgFotos.this.cmdEndlos.setEnabled(false);
            DlgFotos.this.cmdStop.setEnabled(true);
            DlgFotos.this.bilderSchiessen = true;
            this.cntFotos = 0;
            try {
                while (DlgFotos.this.bilderSchiessen) {
                    if (!DlgFotos.this.bildSchiessen()) {
                        JOptionPane.showMessageDialog(DlgFotos.this, DlgFotos.this.errmsg.toString(), "Fehler", 0);
                    } else if (this.nFotos <= 0 || ++this.cntFotos < this.nFotos) continue;
                    break;
                }
            }
            finally {
                DlgFotos.this.cmdOk.setEnabled(true);
                DlgFotos.this.cmdAbbruch.setEnabled(true);
                DlgFotos.this.cmdNochmal.setEnabled(true);
                DlgFotos.this.cmdSerie.setEnabled(true);
                DlgFotos.this.cmdEndlos.setEnabled(true);
                DlgFotos.this.cmdStop.setEnabled(false);
                DlgFotos.this.bilderSchiessen = false;
            }
        }
    }
}

