/*
 * Decompiled with CFR 0.152.
 */
package popometer.graphics;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.ImageObserver;
import popometer.graphics.RectScaler;

public abstract class ScaledImagePoint
extends Point {
    protected int size;
    protected int size2;
    protected RectScaler rectScaler;
    protected boolean zoomed;
    protected Point point;

    public ScaledImagePoint(int size, RectScaler rectScaler) {
        this.size = size;
        this.size2 = size / 2;
        this.x = -1;
        this.y = -1;
        this.rectScaler = rectScaler;
        this.zoomed = false;
        this.point = new Point();
    }

    public void moveScaled(int x, int y) {
        int sz;
        this.point.x = x;
        this.point.y = y;
        this.rectScaler.scaleFrom((Point)this, this.point);
        this.point.x -= this.rectScaler.getX();
        this.point.y -= this.rectScaler.getY();
        int n = sz = this.zoomed ? this.rectScaler.scaleFrom(this.size) : this.size;
        if (this.point.x < this.size) {
            this.x = sz;
        }
        if (this.point.y < this.size) {
            this.y = sz;
        }
        if (this.point.x + this.size >= this.rectScaler.getWidth()) {
            this.x = this.rectScaler.getRealWidth() - sz - 2;
        }
        if (this.point.y + this.size >= this.rectScaler.getHeight()) {
            this.y = this.rectScaler.getRealHeight() - sz - 2;
        }
    }

    public boolean moveZoomed(int x, int y) {
        if (!this.zoomed) {
            return false;
        }
        this.rectScaler.scaleTo(this.point, this);
        x -= this.point.x;
        y -= this.point.y;
        this.x += (x /= 2);
        this.y += (y /= 2);
        return x != 0 || y != 0;
    }

    public boolean coversScaled(int x, int y) {
        if (this.zoomed) {
            this.rectScaler.scaleTo(this.point, this);
            return Math.abs(this.point.x - x) < this.size && Math.abs(this.point.y - y) < this.size;
        }
        this.point.x = x;
        this.point.y = y;
        this.rectScaler.scaleFrom(this.point, this.point);
        return Math.abs(this.point.x - this.x) < this.size2 && Math.abs(this.point.y - this.y) < this.size2;
    }

    public void setZoomed(boolean zoomed) {
        System.out.printf("Zoom %s -> %s bei %d x %d\n", this.zoomed ? "on" : "off", zoomed ? "on" : "off", this.x, this.y);
        this.zoomed = zoomed;
    }

    public boolean isZoomed() {
        return this.zoomed;
    }

    public float distanceTo(ScaledImagePoint marker) {
        if (this.getX() == -1.0 || this.getY() == -1.0) {
            return 0.0f;
        }
        if (marker.getX() == -1.0 || marker.getY() == -1.0) {
            return 0.0f;
        }
        int a = Math.abs(this.x - marker.x);
        int b = Math.abs(this.y - marker.y);
        return (float)Math.sqrt(a * a + b * b);
    }

    public abstract Point paint(Graphics2D var1, Image var2, ImageObserver var3);

    @Override
    public String toString() {
        return "(" + this.getX() + "," + this.getY() + ")";
    }

    public RectScaler getRectScaler() {
        return this.rectScaler;
    }
}

