/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JPanel;
import popometer.graphics.PositionMarker;
import popometer.graphics.SimpleMarker;
import popometer.panels.PanSitzknochen;

public class PanScanImage
extends JPanel {
    private PanSitzknochen panSitzknochen;
    private Image scanImage;
    private PositionMarker positionMarker1;
    private PositionMarker positionMarker2;
    private final float korrektur = 0.0f;
    private float fltAbstand;
    private String strAbstand;
    private int xAbstand;
    private int yAbstand;

    public PanScanImage(PanSitzknochen panSitzknochen, Image image) {
        super(null);
        this.panSitzknochen = panSitzknochen;
        this.positionMarker1 = new SimpleMarker(40);
        this.positionMarker2 = new SimpleMarker(40);
        this.fltAbstand = 0.0f;
        this.strAbstand = null;
        this.xAbstand = 0;
        this.yAbstand = 0;
        this.scanImage = image;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PanScanImage.this.formMouseClicked(evt);
            }
        });
    }

    @Override
    public synchronized void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.drawImage(this.scanImage, 0, 0, 1180, 840, this);
        g2d.setXORMode(Color.ORANGE);
        if (!(this.positionMarker1.getX() <= 0 && this.positionMarker1.getY() <= 0 || this.positionMarker2.getX() <= 0 && this.positionMarker2.getY() <= 0)) {
            int x1 = this.positionMarker1.getX();
            int y1 = this.positionMarker1.getY();
            int x2 = this.positionMarker2.getX();
            int y2 = this.positionMarker2.getY();
            float f = 0.0f / this.fltAbstand;
            int dx = (int)((float)(x1 > x2 ? x1 - x2 : x2 - x1) * f);
            int dy = (int)((float)(y1 > y2 ? y1 - y2 : y2 - y1) * f);
            if (x1 < x2) {
                x1 -= dx;
                x2 += dx;
            } else {
                x1 += dx;
                x2 -= dx;
            }
            if (y1 < y2) {
                y1 -= dy;
                y2 += dy;
            } else {
                y1 += dy;
                y2 -= dy;
            }
            g2d.drawLine(x1, y1, x2, y2);
            double ddx = x2 - x1;
            double ddy = y1 - y2;
            double hyp = Math.sqrt(ddx * ddx + ddy * ddy);
            double sin = ddy / hyp;
            double cos = ddx / hyp;
            int d = (int)this.getXPxPcm() * 3;
            int xa1 = x1 + (int)(sin * (double)d);
            int xa2 = x1 - (int)(sin * (double)d);
            int ya1 = y1 + (int)(cos * (double)d);
            int ya2 = y1 - (int)(cos * (double)d);
            g2d.drawLine(xa1, ya1, xa2, ya2);
            xa1 = x2 + (int)(sin * (double)d);
            xa2 = x2 - (int)(sin * (double)d);
            ya1 = y2 + (int)(cos * (double)d);
            ya2 = y2 - (int)(cos * (double)d);
            g2d.drawLine(xa1, ya1, xa2, ya2);
        }
        g2d.setPaintMode();
        this.positionMarker1.draw(g2d);
        this.positionMarker2.draw(g2d);
        if (this.strAbstand != null) {
            Color color = g2d.getColor();
            g2d.setFont(new Font("Arial Black", 1, 16));
            Rectangle2D rect = g2d.getFont().getStringBounds(this.strAbstand, g2d.getFontRenderContext());
            g2d.setColor(Color.YELLOW);
            int cx = (int)rect.getCenterX();
            int cy = (int)rect.getHeight();
            g2d.drawString(this.strAbstand, this.xAbstand - cx, this.yAbstand - cy / 4);
            g2d.setColor(color);
        }
    }

    public void setImage(Image image) {
        this.scanImage = image;
        this.positionMarker1.moveTo(-1, -1);
        this.positionMarker2.moveTo(-1, -1);
        this.fltAbstand = 0.0f;
        this.strAbstand = null;
        this.repaint();
    }

    private float getXPxPcm() {
        return (float)this.scanImage.getWidth(null) / 29.9f;
    }

    private float getYPxPcm() {
        return (float)this.scanImage.getHeight(null) / 21.6f;
    }

    private void formMouseClicked(MouseEvent evt) {
        int dY;
        int dX;
        int x = evt.getX();
        int y = evt.getY();
        if (this.positionMarker1.getX() <= 0 && this.positionMarker1.getY() <= 0) {
            this.positionMarker1.moveTo(x, y);
        } else if (this.positionMarker2.getX() <= 0 && this.positionMarker2.getY() <= 0) {
            this.positionMarker2.moveTo(x, y);
        } else {
            dX = Math.abs(x - this.positionMarker1.getX());
            dY = Math.abs(y - this.positionMarker1.getY());
            int distSq1 = dX * dX + dY * dY;
            dX = Math.abs(x - this.positionMarker2.getX());
            int distSq2 = dX * dX + (dY = Math.abs(y - this.positionMarker2.getY())) * dY;
            if (distSq2 < distSq1) {
                this.positionMarker2.moveTo(evt.getX(), evt.getY());
            } else {
                this.positionMarker1.moveTo(x, y);
            }
        }
        if (!(this.positionMarker1.getX() <= 0 && this.positionMarker1.getY() <= 0 || this.positionMarker2.getX() <= 0 && this.positionMarker2.getY() <= 0)) {
            dX = Math.abs(this.positionMarker1.getX() - this.positionMarker2.getX());
            dY = Math.abs(this.positionMarker1.getY() - this.positionMarker2.getY());
            float dXcm = (float)dX / this.getXPxPcm();
            float dYcm = (float)dY / this.getYPxPcm();
            float a = (float)Math.sqrt(dXcm * dXcm + dYcm * dYcm);
            NumberFormat fmt = NumberFormat.getNumberInstance(Locale.getDefault());
            if (fmt instanceof DecimalFormat) {
                String numFormat = "##.#";
                ((DecimalFormat)fmt).applyPattern(numFormat);
            }
            a = (float)Math.round(a * 10.0f) / 10.0f;
            this.panSitzknochen.setAbstand(a + 0.0f);
            this.fltAbstand = a;
            this.strAbstand = fmt.format(a) + " cm";
            this.xAbstand = (this.positionMarker1.getX() < this.positionMarker2.getX() ? this.positionMarker1.getX() : this.positionMarker2.getX()) + dX / 2;
            this.yAbstand = (this.positionMarker1.getY() < this.positionMarker2.getY() ? this.positionMarker1.getY() : this.positionMarker2.getY()) + dY / 2;
        }
        this.repaint();
    }
}

