/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import popometer.JNimbusTable;
import popometer.YPopometerSession;
import popometer.dbobjects.YRLVerkaeufer;
import popometer.dbobjects.YROHaendler;
import projektY.base.YException;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDatabaseData;
import projektY.database.YDatabaseList;
import projektY.database.YFKException;
import projektY.swing.YJPanelManager;
import projektY.swing.YJTableManager;

public class PanVerkaeufer
extends JPanel {
    private YROHaendler haendler;
    private JScrollPane panVerkaeufer;
    private JNimbusTable tblVerkaeufer;
    private YRLVerkaeufer verkaeufer;
    private JButton cmdDelete;
    private JButton cmdInsert;
    private JButton cmdPost;
    private JButton cmdRevert;
    private JPasswordField fldPasswort;
    private JPasswordField fldPasswort2;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel lblUeberschrift;
    private JLabel lblUeberschrift1;
    private JPanel panControl;
    private JPanel panFill;
    private JPanel panLinks;
    private JPanel panRechts;
    private JPanel panVerkaeuferdaten;
    private JScrollPane scrlVerkaeufer;

    public PanVerkaeufer(YPopometerSession session, YROHaendler haendler) throws YException {
        this.initComponents();
        this.haendler = haendler;
        this.tblVerkaeufer = new JNimbusTable();
        this.panVerkaeufer = new JScrollPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.scrlVerkaeufer.add((Component)this.panVerkaeufer, gridBagConstraints);
        this.scrlVerkaeufer.setViewportView(this.tblVerkaeufer);
        this.verkaeufer = new YRLVerkaeufer(session);
        this.verkaeufer.getColumnDefinition("login").setLabel("<Login-Name>@" + haendler.getAsString("kundennr"));
        this.verkaeufer.setDispFields(new String[]{"name", "vorname", "login"}, new String[]{"passwd", "passwd2"});
        YJTableManager.createTableManager((JTable)this.tblVerkaeufer, (YDatabaseList)this.verkaeufer);
        YJPanelManager.createPanelManager((JComponent)this.panVerkaeuferdaten, (YDatabaseData)this.verkaeufer);
        this.verkaeufer.fetch();
    }

    public boolean hasChanged() throws YException {
        return this.verkaeufer.hasChanged();
    }

    private void initComponents() {
        this.panLinks = new JPanel();
        this.scrlVerkaeufer = new JScrollPane();
        this.lblUeberschrift = new JLabel();
        this.panRechts = new JPanel();
        this.panVerkaeuferdaten = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel5 = new JLabel();
        this.fldPasswort = new JPasswordField();
        this.fldPasswort2 = new JPasswordField();
        this.jLabel1 = new JLabel();
        this.panFill = new JPanel();
        this.lblUeberschrift1 = new JLabel();
        this.panControl = new JPanel();
        this.cmdPost = new JButton();
        this.cmdRevert = new JButton();
        this.cmdDelete = new JButton();
        this.cmdInsert = new JButton();
        this.setLayout(new GridBagLayout());
        this.panLinks.setBorder(BorderFactory.createTitledBorder(""));
        this.panLinks.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panLinks.add((Component)this.scrlVerkaeufer, gridBagConstraints);
        this.lblUeberschrift.setForeground(new Color(212, 55, 28));
        this.lblUeberschrift.setText("Verk\u00e4ufer");
        this.lblUeberschrift.setName("headline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 17, 0);
        this.panLinks.add((Component)this.lblUeberschrift, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panLinks, gridBagConstraints);
        this.panRechts.setBorder(BorderFactory.createTitledBorder(""));
        this.panRechts.setLayout(new GridBagLayout());
        this.panVerkaeuferdaten.setMinimumSize(new Dimension(250, 127));
        this.panVerkaeuferdaten.setPreferredSize(new Dimension(250, 127));
        this.panVerkaeuferdaten.setLayout(new GridBagLayout());
        this.jLabel4.setText("<Anmeldename>");
        this.jLabel4.setName("login");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.panVerkaeuferdaten.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel6.setText("Passwort best\u00e4tigen:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panVerkaeuferdaten.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel5.setText("Passwort:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.panVerkaeuferdaten.add((Component)this.jLabel5, gridBagConstraints);
        this.fldPasswort.setName("passwd");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panVerkaeuferdaten.add((Component)this.fldPasswort, gridBagConstraints);
        this.fldPasswort2.setName("passwd2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panVerkaeuferdaten.add((Component)this.fldPasswort2, gridBagConstraints);
        this.jLabel1.setText("Anmeldename:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panVerkaeuferdaten.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.panRechts.add((Component)this.panVerkaeuferdaten, gridBagConstraints);
        GroupLayout panFillLayout = new GroupLayout(this.panFill);
        this.panFill.setLayout(panFillLayout);
        panFillLayout.setHorizontalGroup(panFillLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 250, Short.MAX_VALUE));
        panFillLayout.setVerticalGroup(panFillLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 288, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panRechts.add((Component)this.panFill, gridBagConstraints);
        this.lblUeberschrift1.setForeground(new Color(212, 55, 28));
        this.lblUeberschrift1.setText("Zugangsdaten");
        this.lblUeberschrift1.setName("headline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 17, 0);
        this.panRechts.add((Component)this.lblUeberschrift1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.panRechts, gridBagConstraints);
        this.cmdPost.setText("Verk\u00e4ufer speichern");
        this.cmdPost.setToolTipText("Liste speichern");
        this.cmdPost.setFocusable(false);
        this.cmdPost.setHorizontalTextPosition(0);
        this.cmdPost.setVerticalTextPosition(3);
        this.cmdPost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanVerkaeufer.this.cmdPostActionPerformed(evt);
            }
        });
        this.panControl.add(this.cmdPost);
        this.cmdRevert.setText("\u00c4nderungen verwerfen");
        this.cmdRevert.setToolTipText("\u00c4nderungen verwerfen");
        this.cmdRevert.setFocusable(false);
        this.cmdRevert.setHorizontalTextPosition(0);
        this.cmdRevert.setVerticalTextPosition(3);
        this.cmdRevert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanVerkaeufer.this.cmdRevertActionPerformed(evt);
            }
        });
        this.panControl.add(this.cmdRevert);
        this.cmdDelete.setText("Verk\u00e4ufer l\u00f6schen");
        this.cmdDelete.setToolTipText("Verk\u00e4ufer l\u00f6schen");
        this.cmdDelete.setFocusable(false);
        this.cmdDelete.setHorizontalTextPosition(0);
        this.cmdDelete.setVerticalTextPosition(3);
        this.cmdDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanVerkaeufer.this.cmdDeleteActionPerformed(evt);
            }
        });
        this.panControl.add(this.cmdDelete);
        this.cmdInsert.setText("Verk\u00e4ufer hinzuf\u00fcgen");
        this.cmdInsert.setToolTipText("Neuer Verk\u00e4ufer");
        this.cmdInsert.setFocusable(false);
        this.cmdInsert.setHorizontalTextPosition(0);
        this.cmdInsert.setVerticalTextPosition(3);
        this.cmdInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanVerkaeufer.this.cmdInsertActionPerformed(evt);
            }
        });
        this.panControl.add(this.cmdInsert);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.panControl, gridBagConstraints);
    }

    private void cmdInsertActionPerformed(ActionEvent evt) {
        try {
            this.verkaeufer.appendRow();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdDeleteActionPerformed(ActionEvent evt) {
        try {
            this.verkaeufer.clearActiveDispValues();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdRevertActionPerformed(ActionEvent evt) {
        try {
            this.verkaeufer.revert();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdPostActionPerformed(ActionEvent evt) {
        try {
            int nRows = this.verkaeufer.getRowCount();
            String loginEnde = "@" + this.haendler.getAsString("kundennr");
            int lLoginende = loginEnde.length();
            for (int iRow = 0; iRow < nRows; ++iRow) {
                String login;
                if (!this.verkaeufer.hasValuesToStore(iRow) || (login = this.verkaeufer.getAsString(iRow, "login")).length() <= 0 || login.length() > lLoginende && login.endsWith(loginEnde)) continue;
                String loginKorrigiert = login + loginEnde;
                int a = JOptionPane.showConfirmDialog(this, "Der Login-Name von " + this.verkaeufer.getRowValues(iRow).toString() + " mu\u00df die Form '<name>" + loginEnde + " haben.\n" + "Soll der Name in " + loginKorrigiert + " umge\u00e4ndert werden ?", "Ung\u00fcltiger Login-Name", 2, 3);
                if (a == 0) {
                    this.verkaeufer.setAsString(iRow, "login", loginKorrigiert);
                    this.verkaeufer.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, iRow, iRow));
                    continue;
                }
                return;
            }
            this.verkaeufer.post();
        }
        catch (YFKException efk) {
            JOptionPane.showMessageDialog(this, "Der Verk\u00e4ufer kann nicht gel\u00f6scht werden,\nweil dann von ihm erfa\u00dfte Daten nicht mehr zuzuordnen sind.\n\nUm seinen Zugang zum Shop zu l\u00f6schen,\n    dr\u00fccken Sie bitte \"Verwerfen\",\n    l\u00f6schen anschlie\u00dfend seinen Login-Namen und\n    dr\u00fccken noch einmal \"Speichern\".", "Fehler", 0);
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }
}

