#!/bin/bash
# Emailversand mit der Velometrik-Messstation
# Aufruf: email.sh <email_adresse> [<haendler> [<verkaeufer>]]
# Fehlerstatus:
#	1 Emailadresse nicht angegeben
#	2 LaTeXaufruf mit Fehler beendet
#	3 Emailversand mit Fehler beendet

# Emailadresse, Hndler und Verkufer aus der Kommandozeile bernehmen
EMAIL_AN=""
HAENDLER="Velometrik GmbH"
VERKAEUFER=""
ANTWORT_AN="messstaion@velometrik.de"

I=1
while [ $# -gt 0 ]; do
	case $I in
		1) EMAIL_AN=$1
		   ;;
		2) HAENDLER=$1
		   ;;
		3) VERKAEUFER=$1
		   ;;
		4) ANTWORT_AN=$1
		   ;;
	esac
	I=`expr $I + 1`
	shift
done
if [ -z "${EMAIL_AN}" ]; then
	echo "Emailadresse fehlt." 1>&2
	exit 1
fi

TMP_DIR=/home/${USER}/.popometer/tmp
rm -f ${TMP_DIR}/BikeAndFitBeratung.pdf
pdflatex --halt-on-error --output-directory ${TMP_DIR} ${TMP_DIR}/BikeAndFitBeratung.tex > ${TMP_DIR}/BikeAndFitBeratung.log
if [ $? -ne 0 ]; then
	grep "Error:"  ${TMP_DIR}/BikeAndFitBeratung.log | head -1 1>&2
	exit 2
fi
export EMAIL="messstation@velometrik.de"
export REPLYTO=$ANTWORT_AN
echo "Liebe(r) Radsportfreund(in),

im Anhang finden Sie Ihr Vermessungsprotokoll vom `date '+%_d. %B %Y'`.

$VERKAEUFER
$HAENDLER

Das Protokoll wurde mit der Messstation der Velometrik GmbH erstellt.
(http://www.velometrik.de)
" | mutt -s "Ihr Vermessungsprotokoll" -b messprotokoll@velometrik.de -a $TMP_DIR/BikeAndFitBeratung.pdf -- $EMAIL_AN 
[ ${PIPESTATUS[1]} -ne 0 ] && exit 3
exit 0

