#!/bin/bash
# Foto mit Webcam fr popometer schieen.
# Author: Siegmar Mller www.prodam.de
# Erstellt: 3.8.2011
# nderungen:

# set -x

# Im Erfolgsfall ist der Exit-Status 0, sonst 1
# Fehlermeldungen werden an stderr ausgegeben.
# Ab der zweiten Zeile der Fehlermeldung beginnen die Details.

# Einstellungen
VIDEO_DEVICE=/dev/video0
TMP_DIR=/home/${USER}/.popometer/tmp
TMP_FILE=bodyimage.jpeg
ARCHIV_DIR=/home/${USER}/.popometer/bodyimg
FOTOCMD=fswebcam
FOTOCMD_OPTIONS="-d $VIDEO_DEVICE -i 0 -r 1920x1080 -s brightness=45% -s contrast=13% --jpeg 95 --no-banner --crop 1080x1080,420x0 --save ${TMP_DIR}/${TMP_FILE} -p MJPEG -q"

#TODO Wir brauchen die Meldungen noch abhngig von $LANG.
# Da mu wohl printf benutzt werden.
# Webcam connected ?\n/dev/video0 is not available or no character device.

# Prfen der Umgebung
if [ ! -c $VIDEO_DEVICE ]; then
	echo -e "Ist die Webcam angeschlossen ?\n$VIDEO_DEVICE ist nicht verfgbar oder kein zeichenorientiertes Gert." 1>&2
	exit 1
fi
if [ ! -d $TMP_DIR ]; then
	mkdir $TMP_DIR
	if [ $? -ne 0 ]; then
		echo -e "Das Verzeichnis $TMP_DIR existiert nicht und lt sich nicht anlegen." 1>&2
		exit 1
	fi
fi
which $FOTOCMD > /dev/null
if [ $? -ne 0 ]; then
	echo -e "Ist $FOTOCMD intalliert ?\nDas Kommando befindet sich nicht im aktuellen Pfad:\n$PATH" 1>&2
	exit 1
fi
rm -f ${TMP_DIR}/${TMP_FILE} # Datei mu nach dem Fotokommando wieder da sein.
eval $FOTOCMD $FOTOCMD_OPTIONS
# Der exit-Status ist bei diesem Programm immer 0
# Es gibt immer Fehlermeldungen, auch wenn das Bild O.K. ist !
echo "Exitstatus $?"
if [ ! -f ${TMP_DIR}/${TMP_FILE} ]; then
	echo -e "Das Foto konnte nicht geschossen werden.\nDie Bilddatei ${TMP_DIR}/${TMP_FILE} existiert nicht."
fi
