/*
Copyright (C) 2021 Velometrik GmbH
<http://www.velometrik.de/>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/* 
    Created on : 04.06.2021, 21:08:29
    Author     : Peter Bauer
*/


/**
 * `fs()` is the function that is called when the page is loaded. It calls `localstart()` which sets up
 * the local storage, `translatejs()` which translates the page, and `drawCanvas()` which draws the
 * canvas
 */
 function fs() {
//   localstart();
}

/**
* If the checkbox is checked, set the localStorage item "ReadFirstStart" to true, otherwise set it to
* false
*/
function setFirstStart() {
  const firststart = document.getElementById("chb_firststart");
  if (firststart.checked) {
      localStorage.setItem("ReadFirstStart", true);
  } else {
      localStorage.setItem("ReadFirstStart", false);
  }
}



/**
* It checks the local storage for the value of the key 'viewmode'. If the value is 'basic', it adds
* the class 'basicview' to all elements with the class 'adba'. If the value is 'advanced', it removes
* the class 'basicview' from all elements with the class 'adba'
* @param {string} mode - This is the view mode you want to switch to.
*/
function ToggleViewMode(mode) {
  localStorage.setItem("viewmode", mode);

  if (localStorage.getItem("viewmode") === "basic") {
    //   document.getElementById("ModeBasic").classList.add("link_focus");
    //   document.getElementById("ModeAdvanced").classList.remove("link_focus");
      for (
          let index = 0; index < document.getElementsByClassName("adba").length; index++
      ) {
          const element = document.getElementsByClassName("adba")[index];
          element.classList.add("basicview");
      }
  } else if (localStorage.getItem("viewmode") === "advanced") {
    //   document.getElementById("ModeBasic").classList.remove("link_focus");
    //   document.getElementById("ModeAdvanced").classList.add("link_focus");
      for (
          let index = 0; index < document.getElementsByClassName("adba").length; index++
      ) {
          const element = document.getElementsByClassName("adba")[index];
          element.classList.remove("basicview");
      }
  }
}

function setFirstSatteldruckanalyse() {
  const firstSatteldruckanalyse = document.getElementById(
      "chb_firstSatteldruckanalyse"
  );
  if (firstSatteldruckanalyse.checked) {
      localStorage.setItem("ReadFirstSatteldruckanalyse", true);
  } else {
      localStorage.setItem("ReadFirstSatteldruckanalyse", false);
  }
}


var custommask = 
 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
  0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
  0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
  0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
  0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
  0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
  0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
  0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
  0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
  0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
  0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
  0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
];
/* Creating a grid of divs with the class "a" and the id "Mp"+id. */
if (document.getElementsByClassName('live')[0])
  for (let i = 0; i < 28; i++) {
      for (let j = 0; j < 16; j++) {
          let id = i * 16 + j;
          let x = document.createElement('div');
          x.setAttribute("onclick", `toogleMaskpoint(${i},${j},${id})`)
          x.id = "Mp" + id
          x.classList.add("a");
          document.getElementsByClassName('live')[0].append(x);
          tM(i, j, id)
      }
  }

if (document.getElementsByClassName('Frame-3')[0])
  for (let i = 0; i < 28; i++) {
      let e = document.createElement('div');
      e.classList.add("row" + i, "line")
      document.getElementsByClassName('Frame-3')[0].append(e);
      for (let j = 0; j < 16; j++) {
          let id = i * 16 + j;
          let x = document.createElement('div');
          x.setAttribute("onclick", `toogleMaskpoint(${i},${j},${id})`)
          x.id = "Mp" + id
          x.classList.add("grid_a")
          x.classList.add("a");
          document.getElementsByClassName('row' + i)[0].append(x);
          tM(i, j, id)

      }
  }

/**
* It takes the contents of the custommask array and sends it to the server
*/
function sendMask() {
  // if (typeof conn == "object" && conn.readyState == WebSocket.OPEN) {
  var cmd = "set mask"

  for (i = 0; i < 28; ++i) {
      for (j = 0; j < 16; ++j) {
          cmd += " ";
          cmd += custommask[i * 16 + j];
      }
  }
  // console.log("send mask");
  sattelanalyse.send(cmd);

  sattelanalyse.send('set mask custom')
      // console.log(cmd);
      // conn.send (cmd);
      // } else {
      // alert ("Must connect.");
      // }
}

function saveMask(name) {
    name=name.replaceAll(" ","");
    name=name.replace("10","X");
    name=name.replace("1","I");
    name=name.replace("2","II");
    name=name.replace("3","III");
    name=name.replace("4","IV");
    name=name.replace("5","V");
    name=name.replace("6","VI");
    name=name.replace("7","VII");
    name=name.replace("8","VIII");
    name=name.replace("9","IX");
    var cmd = `set mask -store ${name}`

    for (i = 0; i < 28; ++i) {
        for (j = 0; j < 16; ++j) {
            cmd += " ";
            cmd += custommask[i * 16 + j];
        }
    }
    // console.log("send mask");
    sattelanalyse.send(cmd);
    sattelanalyse.send(`set mask ${name}`)
    hide_mask();
    add_mask(name)
    // onsqlresult = Maskmenue;
    // sattelanalyse.send(`sql select name from masks where mask_id > 4`);
}

/**
* It toggles the maskpoint at the given index, and sends the mask to the server
* @param i - the row of the Mp
* @param j - the number of rows
* @param idx - the index of the Mp in the custommask array
*/
function toogleMaskpoint(i, j, idx) {
    console.log(i,j,idx);
  var id = "Mp" + idx;
  if (custommask[idx] == 1) {
      custommask[idx] = 0;
      document.getElementById(id).style.backgroundColor = 'rgb(255 255 255 / 0%)'
      sendMask()
  } else {
      custommask[idx] = 1;
      document.getElementById(id).style.backgroundColor = '#e50e0e52'
      sendMask()
  }
}

function tM(i, j, idx) {
  var id = "Mp" + idx;

  if (custommask[idx] == 1) {
      custommask[idx] = 0;
      document.getElementById(id).style.backgroundColor = 'rgb(255 255 255 / 0%)'
  } else {
      custommask[idx] = 1;
      document.getElementById(id).style.backgroundColor = '#e50e0e52'
  }
}

