/*
Copyright (C) 2021 Velometrik GmbH
<http://www.velometrik.de/>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/* 
    Created on : 04.06.2021, 21:08:29
    Author     : Peter Bauer
*/
const client_id = localStorage.getItem('client_id');
const client_name = localStorage.getItem('client_name');
const client_mail = localStorage.getItem('client_mail')||'nicht vorhanden';
const client_fc = localStorage.getItem('client_fc');
const client_info =  JSON.parse(localStorage.getItem('client_info'));

var Nname = document.getElementById('pi_name');
var Vname = document.getElementById('pi_vorname');
var Email = document.getElementById('pi_email');

document.getElementById('client_head').innerHTML = client_name;
Nname.innerHTML =  client_name.split(' ')[0];
Vname.innerHTML =  client_name.split(' ')[1];
Email.innerHTML =  client_mail;
document.getElementById('pi_id').innerHTML = client_id;
document.getElementById('pi_fc').innerHTML = client_fc.split(' ')[0];

newElement({element:"button",cls:['quad-35','uk-button','uk-button-primary','mdi','mdi-bike','uk-button-small'],attr:[['key-title','cli_new_session'],['style','font-size:16pt'],['onclick',`new_session_id(${client_id})`]]},document.getElementById('pi_newSession'))

gen_session_list()

function gen_session_list() {
    let into = document.getElementById('pi_sl');
    let head = ['Session','Datum','info','']
    let table = document.createElement('table')
    table.classList.add('uk-table', 'uk-table-hover', 'uk-table-divider')
    into.append(table)
    let thead = document.createElement('thead');
    table.append(thead)
    let tr_head = document.createElement('tr');
    thead.append(tr_head);
    head.forEach(e=>{
        let th_head = document.createElement('th');
        th_head.innerHTML = e;
        th_head.setAttribute('key',`cli_tablehead_${e}`)
        tr_head.append(th_head);
    })
    let tbody = document.createElement('tbody');
    table.append(tbody);

    client_info.forEach(e => {
        var tr_body = document.createElement('tr');
        // tr_body.setAttribute('uk-tooltip',`${aLangKeys[lang]['tooltip_session_retrive']}`)
        tr_body.classList.add('cur_pointer')
        tr_body.id = `cli_${e.session_id}`
        // tr_body.setAttribute('onclick',`rest_session(${e.session_id})`)
        tbody.append(tr_body);
        tr_body.innerHTML  = `<td onclick='session_img(${e.session_id},"${e.notes||""}")'>${e.session_id}</td>`;
        tr_body.innerHTML += `<td onclick='session_img(${e.session_id},"${e.notes||""}")'>${e.date}</td>`;
        tr_body.innerHTML += `<td onclick='session_img(${e.session_id},"${e.notes||""}")'>${e.notes||""}</td>`;
        // tr_body.innerHTML += `<td><button class="uk-button uk-button-default uk-button-small" onclick="toProtokoll(${e.session_id})" uk-icon="icon: copy"></button></td>`;
        tr_body.innerHTML += `<td><button class="ico-16 mdi mdi-trash-can-outline uk-button uk-button-default uk-button-small adba basicview" onclick="SessionDel(${e.session_id})"></button></td>`
    });
    ToggleViewMode(localStorage.getItem("viewmode"));
    translatejs()    
}

function toProtokoll(id){
  localStorage.setItem('session',`restart ${id}`);
  location.pathname = '/production/protokoll.tcls';
}

function toGalerie(id){
  localStorage.setItem('session',`restart ${id}`);
  location.pathname = '/production/galerie.tcls';
}

var NnameI,VnameI,EmailI
var cli_edit = document.getElementById('cli_edit')
function editData() {
  if(Nname.childElementCount===0){
  cli_edit.setAttribute('key-title','cli_edit_save')
  cli_edit.classList.remove('mdi-content-save-edit')
  cli_edit.classList.add('mdi-content-save')
  NnameI = newElement({element:'input',cls:['uk-input','uk-input-small'],attr:[['value',Nname.innerHTML]]},Nname)
  VnameI = newElement({element:'input',cls:['uk-input','uk-input-small'],attr:[['value',Vname.innerHTML]]},Vname)
  EmailI = newElement({element:'input',cls:['uk-input','uk-input-small'],attr:[['value',Email.innerHTML]]},Email)
  // NnameI = document.createElement('input');
  // NnameI.value=Nname.innerHTML;
  // VnameI = document.createElement('input');
  // VnameI.value=Vname.innerHTML;
  // EmailI = document.createElement('input');
  // EmailI.value=Email.innerHTML;

  Nname.innerHTML="";
  Vname.innerHTML="";
  Email.innerHTML="";
  Nname.append(NnameI);
  Vname.append(VnameI);
  Email.append(EmailI);
  } else{
    cli_edit.setAttribute('key-title','cli_edit')
    cli_edit.classList.add('mdi-content-save-edit')
    cli_edit.classList.remove('mdi-content-save')
    Nname.innerHTML=NnameI.value;
    Vname.innerHTML=VnameI.value;
    Email.innerHTML=EmailI.value;
    localStorage.setItem('client_mail',Email.innerHTML);
    localStorage.setItem('client_name',`${Nname.innerHTML} ${Vname.innerHTML}`);
    document.getElementById('client_head').innerHTML = `${Nname.innerHTML} ${Vname.innerHTML}`;
    document.getElementById('client').innerHTML = `${Nname.innerHTML} ${Vname.innerHTML}`;
    session.send(`sql UPDATE clients SET email='${Email.innerHTML}', forename='${Vname.innerHTML}', surname='${Nname.innerHTML}' WHERE client_id=${localStorage.getItem('client_id')}`)
  }
translatejs();

}
