#!/bin/bash
#
# velobox_update_3.0.3
# Einspielen aller Dateien in /usr/local/vmkstationd3/
# Velometrik-GmbH
# Breunsdorfer Str. 48a
# 04575 Neukieritzsch
#
# www.velometrik.com
# support@velometrik.de
#
# Historie:
# 31.03.2023	Björn Bauer	erstellt

LAST_VERSION=3.0.2
CURRENT_VERSION=3.0.3

if [ `whoami` != "root" ]; then
echo "ERROR"
	echo "The script must be executed by root!"
	exit 1
fi

if [ `awk -F '=' '/VERSION/ {print $2}' /usr/local/etc/velobox.conf` != $LAST_VERSION ]; then
echo "ERROR"
	echo "Please install update velobox_update_$LAST_VERSION.tar.gz first!"
	exit 1
fi

echo "Delete htdocs"
rm -r /usr/local/vmkstationd3/htdocs/
if [ $? -ne 0 ]; then
echo "ERROR"
	echo "The folder "htdocs" could not be deleted!"
	exit 1
fi

echo "Files in / will be installed."
if [ ! -r velobox_update_$CURRENT_VERSION.tar.gz ]; then
echo "ERROR"
	echo "velobox_update_$CURRENT_VERSION.tar.gz not found" 
	exit 1
fi

cp velobox_update_$CURRENT_VERSION.tar.gz /
if [ $? -ne 0 ]; then
echo "ERROR"
	echo "Can't copy velobox_update_$CURRENT_VERSION.tar.gz to / ."
	exit 1
fi

cd /
test $? -ne 0 && exit 1
tar xf velobox_update_$CURRENT_VERSION.tar.gz
test $? -ne 0 && exit 1
rm -f velobox_update_$CURRENT_VERSION.tar.gz

echo "Files in / were recorded."

### Do not change anything from here on! ###

#################################
### Write the current version ###
echo "Set current version to $CURRENT_VERSION"
sed -i s/VERSION=$LAST_VERSION/VERSION=$CURRENT_VERSION/g /usr/local/etc/velobox.conf
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "Can't set current version to $CURRENT_VERSION"
    exit 1
fi

#########################
### Adapt user rights ###
echo "Correct user rights in htdocs"
chown -R root:root /usr/local
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "User rights could not be corrected!"
    exit 1
fi

history -c

echo "Done!"