--
-- create_vlbsettings_sqlite3.sql
-- Erstellt die lokale Datenbank für die Apps des Stationsdaemon
--

DROP TABLE IF EXISTS antwortvorgaben;
DROP TABLE IF EXISTS fragen;
DROP TABLE IF EXISTS fragebloecke;
DROP TABLE IF EXISTS sprachindizes;
DROP TABLE IF EXISTS appsettings;

DROP TABLE IF EXISTS appquestions;
DROP TABLE IF EXISTS appsections;
DROP TABLE IF EXISTS applications;

DROP TABLE IF EXISTS nextids;


-- Definitions from "vmkprodukte"


CREATE TABLE fragebloecke (
    frageblock_id INTEGER CONSTRAINT idx_fragebloecke_pkey PRIMARY KEY,
    pos_nr SMALLINT NOT NULL,
    code VARCHAR(40) NOT NULL,
    texte TEXT NOT NULL
);
CREATE UNIQUE INDEX IF NOT EXISTS idx_fragebloecke_pkey ON fragebloecke(frageblock_id);

CREATE TABLE fragen (
    frage_id INTEGER CONSTRAINT idx_fragen_pkey PRIMARY KEY,
    frageblock_id INTEGER NOT NULL REFERENCES fragebloecke(frageblock_id) ON DELETE RESTRICT,
    pos_nr SMALLINT NOT NULL,
    antworttyp SMALLINT NOT NULL,
    code VARCHAR(40) NOT NULL,
    texte TEXT NOT NULL
);
CREATE UNIQUE INDEX IF NOT EXISTS idx_fragen_pkey ON fragen(frage_id);

CREATE TABLE antwortvorgaben (
    antwortvorgabe_id INTEGER CONSTRAINT idx_antwortvorgaben_pkey PRIMARY KEY,
    frage_id INTEGER NOT NULL REFERENCES fragen(frage_id) ON DELETE RESTRICT,
    pos_nr SMALLINT NOT NULL,
    code VARCHAR(40) NOT NULL,
    standard INTEGER NOT NULL DEFAULT 0,
    texte TEXT NOT NULL
);
CREATE UNIQUE INDEX IF NOT EXISTS idx_antwortvorgaben_pkey ON antwortvorgaben(antwortvorgabe_id );

CREATE TABLE sprachindizes (
    sprachindex_id INTEGER CONSTRAINT idx_sprachindizes_pkey PRIMARY KEY,
    "index" SMALLINT NOT NULL,
    code CHAR(3) NOT NULL,
    auswahltext TEXT NOT NULL
);
CREATE UNIQUE INDEX IF NOT EXISTS idx_sprachindizes_pkey ON sprachindizes(sprachindex_id);
CREATE UNIQUE INDEX IF NOT EXISTS idx_sprachindizes_index ON sprachindizes("index");


CREATE TABLE appsettings (
    app VARCHAR(40) CONSTRAINT idx_appsettings_pkey PRIMARY KEY,
    settings TEXT NOT NULL DEFAULT '{}'
);
CREATE UNIQUE INDEX IF NOT EXISTS idx_appsettings_pkey ON appsettings(app);


-- Applications

CREATE TABLE nextids (
    table_name VARCHAR CONSTRAINT idx_nextids_pkey PRIMARY KEY,
    id_name VARCHAR NOT NULL,
    next_id INTEGER NOT NULL DEFAULT 1
);

CREATE TABLE applications (
    app_id INTEGER CONSTRAINT idx_applications_pkey PRIMARY KEY,
    name VARCHAR(40) NOT NULL,
    appsettings TEXT NOT NULL DEFAULT '{}',
    clientsettings TEXT NOT NULL DEFAULT '{}'
);
CREATE UNIQUE INDEX IF NOT EXISTS idx_applications_pkey ON applications(app_id);
INSERT INTO nextids (table_name, id_name) VALUES ('applications', 'app_id');

CREATE TABLE appsections (
    appsection_id INTEGER CONSTRAINT idx_appsections_pkey PRIMARY KEY,
    app_id INTEGER NOT NULL REFERENCES applications(app_id) ON DELETE CASCADE,
    pos_nr INTEGER NOT NULL,
    code VARCHAR(40) NOT NULL,
    texte TEXT NOT NULL
);
CREATE UNIQUE INDEX IF NOT EXISTS idx_appsections_pkey ON appsections(appsection_id);
INSERT INTO nextids (table_name, id_name) VALUES ('appsections', 'appsection_id');

CREATE TABLE appquestions (
    appsection_id INTEGER NOT NULL REFERENCES applications(appsection_id) ON DELETE CASCADE,
    frage_id INTEGER NOT NULL REFERENCES fragen(frage_id) ON DELETE CASCADE,
    pos_nr INTEGER NOT NULL
);
CREATE UNIQUE INDEX IF NOT EXISTS idx_appsections_pkey ON appquestions(appsection_id, frage_id);

