document.getElementById("ws_url").value = `ws://${window.location.hostname}:${window.location.port}/apps/sitzknochenabstand`

/**
 * The function updates the image source of an element with the id "hockerbild" to prevent caching.
 */
function hockerbildAktualisieren () {
    // Der Zeitstempel verhindert die Benutzung des letzten Bildes im Cache.
    document.getElementById("hockerbild").src = "/hockerbild?rnd="+(new Date).getTime();
}

/**
 * The function `handleWSMessage` is used to handle different types of WebSocket messages and update
 * the HTML content accordingly.
 * @param wsmessage - The `wsmessage` parameter is a string that represents a message received from a
 * WebSocket connection.
 * @returns In the code provided, there is no explicit return statement. Therefore, the function will
 * implicitly return undefined.
 */
function handleWSMessage (wsmessage) {
    var msg;

    try {
         msg = JSON.parse (wsmessage);
    } catch (error) {
        console.log (`Kein gültiger JSON-String: "${wsmessage}"`);
        return;
    }
    if (msg.wsevent == "hockerbild") {
	        hockerbildAktualisieren();
    } else if (msg.wsevent == "hockernorm") {
        // {"wsevent": "hockernorm", "imagetype": "ska_live", "n_rows": 16, "n_cols": 28, "values": [...]}
        var i;
        var v;

        for (i=0; i<msg.n_rows*msg.n_cols; ++i) {
            v = msg.values[i];
            let el = document.getElementById(`nv${i}`)

            if(v==0){
                el.innerHTML = `000`
                el.removeAttribute('style')
                el.setAttribute('style','color:black; margin: 2px;')
            } else if (v < 10) {
                el.innerHTML = `00${v}`;
                el.removeAttribute('style')
                el.setAttribute('style','color:red; margin: 2px;')
            } else if (v < 100) {
                el.innerHTML = `0${v}`;
                el.removeAttribute('style')
                el.setAttribute('style','color:red; margin: 2px;')
            } else {
                el.innerHTML = v;
                el.removeAttribute('style')
                el.setAttribute('style','color:red; margin: 2px;')
            }
        }
    } else {
	        document.getElementById("message").innerHTML = wsmessage.replace(/</g,"&lt;").replace(/>/g,"&gt;");
    }
}

var conn;


/**
 * The function "connect" establishes a WebSocket connection and handles the different states of the
 * connection.
 * @returns The function `connect()` returns nothing.
 */
function connect () {
    if (window.WebSocket) {
        // Evtl. bestehende Verbindung schließen
        if (typeof conn == "object" && conn.readyState == WebSocket.OPEN) conn.close();

        // Verbindung herstellen
        try {
            // Der Server erwartet wenigstens ein (Sub)Protokoll, auch wenn das nicht benutzt wird.
            conn = new WebSocket(document.getElementById("ws_url").value, "dummy");
        } catch (error) {
            //??? nur SECURITY_ERROR
            document.getElementById("statusinfo").innerHTML = "Wenn das 'mal kein Fehler ist.";
        }
        switch (conn.readyState) {
            case WebSocket.CONNECTING: // Die Verbindung ist noch nicht hergestellt.
                document.getElementById("statusinfo").innerHTML = "WebSocket-Verbindung wird hergestellt.";
                conn.onopen = function (evt) {
                    document.getElementById("statusinfo").innerHTML = "WebSocket-Verbindung ist hergestellt.";
                    conn.onclose = function (evt) {
                        document.getElementById("statusinfo").innerHTML = "WebSocket-Verbindung wurde geschlossen.";
                        document.getElementById("message").innerHTML = "";
                    };
                };
                conn.onclose = function (evt) {
                    document.getElementById("statusinfo").innerHTML = "WebSocket-Verbindung konnte nicht hergestellt werden.";
                };
                break;
            case WebSocket.OPEN:       // Verbindung ist hergestellt und bereit darüber zu kommunizieren.
                document.getElementById("statusinfo").innerHTML = "WebSocket-Verbindung ist hergestellt.";
                break;
            case WebSocket.CLOSING:    // Verbindung ist im Prozess des Schließens.
            case WebSocket.CLOSED:     // Die Verbindung konnte nicht hergestellt werden.
                document.getElementById("statusinfo").innerHTML = "WebSocket-Verbindung konnte nicht hergestellt werden.";
                break;
        }
        // Eingetroffene Meldung vom Server bearbeiten
        conn.onmessage = function (evt) {
            handleWSMessage (evt.data);
        };
		return;
    }
	document.getElementById("statusinfo").innerHTML = "WebSocket ist in diesem Browser nicht verfügbar";
}

/**
 * The function checks if the WebSocket connection is open and closes it if it is.
 */
function disconnect () {
    if (typeof conn == "object" && conn.readyState == WebSocket.OPEN) {
		conn.close();
	}
}


/**
 * The function sends a message through a WebSocket connection if it is open, otherwise it displays an
 * alert message.
 */
function sendMessage () {
    if (typeof conn == "object" && conn.readyState == WebSocket.OPEN) {
        conn.send (document.getElementById("message2send").value);
    } else {
        alert ("Must connect.");
    }
}

/**
 * The clearMessage function clears the value of an input field with the id "message2send".
 */
function clearMessage() {
    document.getElementById("message2send").value = "";
}

/**
 * The function `genNormFrame` generates a grid of div elements with unique IDs based on the provided
 * number.
 * @param num - The `num` parameter is used to determine the ID of the frame element that will be
 * modified. It is an integer value that can be 0, 1, or 2.
 */
function genNormFrame(num) {
    const frame = document.getElementById(`norm${num}`)
    let lnv = num ===2 ? "i2nv" : num ===1 ? "i1nv" : num===0 ? "nv" : ""

    let html=""

    for (i_row=15; i_row>=0; --i_row) {
        i = i_row * 28;
        html += "<div style='display: flex'>";
        for (i_col=0; i_col<28; ++i_col) {
            html += `<div id="${lnv}${i}" style="margin: 2px">000</div>`;
            ++i;
        }
        html += "</div>";
    }
    frame.innerHTML=html
}

genNormFrame(0)
