/*
Copyright (C) 2021 Velometrik GmbH
<http://www.velometrik.de/>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/* 
    Created on : 04.06.2021, 21:08:29
    Author     : Peter Bauer
*/


/**
 * `fs()` is the function that is called when the page is loaded. It calls `localstart()` which sets up
 * the local storage, `translatejs()` which translates the page, and `drawCanvas()` which draws the
 * canvas
 */
 function fs() {
//   localstart();
}

/**
* If the checkbox is checked, set the localStorage item "ReadFirstStart" to true, otherwise set it to
* false
*/
function setFirstStart() {
  const firststart = document.getElementById("chb_firststart");
  if (firststart.checked) {
      saveToLocalStorage("ReadFirstStart", true);
  } else {
      saveToLocalStorage("ReadFirstStart", false);
  }
}



/**
* It checks the local storage for the value of the key 'viewmode'. If the value is 'basic', it adds
* the class 'basicview' to all elements with the class 'adba'. If the value is 'advanced', it removes
* the class 'basicview' from all elements with the class 'adba'
* @param {string} mode - This is the view mode you want to switch to.
*/
function ToggleViewMode(mode) {
  saveToLocalStorage("viewmode", mode);

  if (getFromLocalStorage("viewmode") === "basic") {
    //   document.getElementById("ModeBasic").classList.add("link_focus");
    //   document.getElementById("ModeAdvanced").classList.remove("link_focus");
      for (
          let index = 0; index < document.getElementsByClassName("adba").length; index++
      ) {
          const element = document.getElementsByClassName("adba")[index];
          element.classList.add("basicview");
      }
  } else if (getFromLocalStorage("viewmode") === "advanced") {
    //   document.getElementById("ModeBasic").classList.remove("link_focus");
    //   document.getElementById("ModeAdvanced").classList.add("link_focus");
      for (
          let index = 0; index < document.getElementsByClassName("adba").length; index++
      ) {
          const element = document.getElementsByClassName("adba")[index];
          element.classList.remove("basicview");
      }
  }
}

/**
 * The function sets a value in the local storage based on the checked state of a checkbox element.
 */
function setFirstSatteldruckanalyse() {
  const firstSatteldruckanalyse = document.getElementById(
      "chb_firstSatteldruckanalyse"
  );
  if (firstSatteldruckanalyse.checked) {
      saveToLocalStorage("ReadFirstSatteldruckanalyse", true);
  } else {
      saveToLocalStorage("ReadFirstSatteldruckanalyse", false);
  }
}


var custommask = 
 [0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
  0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
  0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
  0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
  0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
  0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
  0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
  0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
  0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
  0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
  0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
  0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
];

liveMask();
frame3Mask();

/**
 * The function `liveMask` dynamically creates and initializes mask points within a grid structure for
 * a live editing feature.
 */
function liveMask(){
    if (document.getElementsByClassName('live')[0])
        for (let i = 0; i < 28; i++) {
            for (let j = 0; j < 16; j++) {
                let id = i * 16 + j;
                let x = document.createElement('div');
                x.setAttribute("onchange", `toogleMaskpoint(${i},${j},${id})`)
                x.id = "Mp" + id
                x.classList.add("a");
                document.getElementsByClassName('live')[0].append(x);
                tM(i, j, id)
            }
        }
}

/**
 * The function `frame3Mask` creates a grid layout with rows and columns, each containing a div element
 * with specific classes and attributes.
 */
//function frame3Mask(){
//    if (document.getElementsByClassName('Frame-3')[0])
//        for (let i = 0; i < 28; i++) {
//            let e = document.createElement('div');
//            e.classList.add("row" + i, "line")
//            document.getElementsByClassName('Frame-3')[0].append(e);
//            for (let j = 0; j < 16; j++) {
//                let id = i * 16 + j;
//                let x = document.createElement('div');
//                x.setAttribute("onchange", `toogleMaskpoint(${i},${j},${id})`)
//                x.id = "Mp" + id
//                x.classList.add("grid_a")
//                x.classList.add("a");
//                document.getElementsByClassName('row' + i)[0].append(x);
//                tM(i, j, id)
      
//            }
//        }
//}

function frame3Mask() {
  // Übergeordnetes Div erstellen
  if (document.getElementsByClassName('Frame-3')[0]) {
    let maskGrid = document.createElement('div');
    maskGrid.id = 'mask_grid';
    document.getElementsByClassName('Frame-3')[0].append(maskGrid);
      for (let i = 0; i < 28; i++) {
          let e = document.createElement('div');
          e.classList.add("row" + i, "line");
          // Zeilen-Div an das übergeordnete Div anhängen
          maskGrid.append(e);

          for (let j = 0; j < 16; j++) {
              let id = i * 16 + j;
              let x = document.createElement('div');
              x.setAttribute("onchange", `toogleMaskpoint(${i},${j},${id})`);
              x.id = "Mp" + id;
              x.classList.add("grid_a");
              x.classList.add("a");
              document.getElementsByClassName('row' + i)[0].append(x);
              tM(i, j, id);
          }
      }
  }
}

/* This code block is checking if there is an element with the class name 'Frame-3' in the document. If
such an element exists, it creates a grid of div elements and appends them to the 'Frame-3' element. */


/**
* It takes the contents of the custommask array and sends it to the server
*/
function sendMask() {
  // if (typeof conn == "object" && conn.readyState == WebSocket.OPEN) {
  var cmd = "set mask"

  for (i = 0; i < 28; ++i) {
      for (j = 0; j < 16; ++j) {
          cmd += " ";
          cmd += custommask[i * 16 + j];
      }
  }
  // console.log("send mask");
  sattelanalyse.send(cmd);

  sattelanalyse.send('set mask custom')
      // console.log(cmd);
      // conn.send (cmd);
      // } else {
      // alert ("Must connect.");
      // }
}

/**
 * The function `saveMask` takes a name as input, manipulates it to create a mask name, and then sends
 * a command to save the mask with that name.
 * @param name - The name of the mask to be saved.
 */
function saveMask(name) {

    let checkbox = document.getElementById('maskedit')
    checkbox.checked = false
    //checkbox.nextSibling.classList.remove('custom_switch')

    name=name.replaceAll(" ","");
    name=name.replace("10","X");
    name=name.replace("1","I");
    name=name.replace("2","II");
    name=name.replace("3","III");
    name=name.replace("4","IV");
    name=name.replace("5","V");
    name=name.replace("6","VI");
    name=name.replace("7","VII");
    name=name.replace("8","VIII");
    name=name.replace("9","IX");
    var cmd = `set mask -store ${name}`

    for (i = 0; i < 28; ++i) {
        for (j = 0; j < 16; ++j) {
            cmd += " ";
            cmd += custommask[i * 16 + j];
        }
    }
    // console.log("send mask");
    sattelanalyse.send(cmd);
    sattelanalyse.send(`set mask ${name}`)
    hide_mask();
    add_mask(name)
    // onsqlresult = Maskmenue;
    // sattelanalyse.send(`sql select name from masks where mask_id > 4`);
}

/**
* It toggles the maskpoint at the given index, and sends the mask to the server
* @param i - the row of the Mp
* @param j - the number of rows
* @param idx - the index of the Mp in the custommask array
*/
function toogleMaskpoint(i, j, idx) {
    console.log(i,j,idx);
  var id = "Mp" + idx;
  if (custommask[idx] == 1) {
      custommask[idx] = 0;
      document.getElementById(id).style.backgroundColor = 'rgb(255 255 255 / 0%)'
      sendMask()
  } else {
      custommask[idx] = 1;
      document.getElementById(id).style.backgroundColor = '#d79292'//'#e50e0e52'
      sendMask()
  }
}

/**
 * The function `tM` toggles the background color of an element based on the value of
 * `custommask[idx]`.
 * @param i - The parameter "i" is not used in the given code snippet. It is not clear what it
 * represents without further context.
 * @param j - The parameter "j" is not used in the given function. It is not clear what its purpose is.
 * @param idx - The parameter "idx" represents the index of the custommask array.
 */
function tM(i, j, idx) {
  var id = "Mp" + idx;

  if (custommask[idx] == 1) {
      custommask[idx] = 0;
      document.getElementById(id).style.backgroundColor = 'rgb(255 255 255 / 0%)'
  } else {
      custommask[idx] = 1;
      document.getElementById(id).style.backgroundColor = '#d79292'//'#e50e0e52'
  }
}

let isMouseDown = false; // Verfolgt, ob die Maustaste gedrückt ist
let lastToggledElement = null; // Verfolgt das zuletzt getogglete Element

// Event listener für den Anfang des Klickens (Mouse Down)
document.addEventListener('mousedown', (event) => {
  const element = event.target;
  if (element.classList.contains('grid_a')) {
    isMouseDown = true;
    lastToggledElement = element; // Setzt das aktuelle Element als das zuletzt getogglete
    toggleElement(element); // Toggle das erste Element
    event.preventDefault(); // Verhindert unerwünschtes Selektieren von Text
  }
});

// Event listener für das Bewegen der Maus (Mouse Move) während des Klickens
document.addEventListener('mousemove', (event) => {
  if (isMouseDown) {
    const element = document.elementFromPoint(event.clientX, event.clientY); // Ermittelt das Element unter der Maus
    if (element && element.classList.contains('grid_a') && element !== lastToggledElement) {
      toggleElement(element); // Toggle das Element nur, wenn es sich um ein neues handelt
      lastToggledElement = element; // Aktualisiert das zuletzt getogglete Element
    }
  }
});

// Event listener für das Loslassen der Maustaste (Mouse Up)
document.addEventListener('mouseup', () => {
  isMouseDown = false; // Setzt den Zustand "Maustaste nicht mehr gedrückt"
  lastToggledElement = null; // Setzt das zuletzt getogglete Element zurück
});

// Hilfsfunktion, um ein Element umzuschalten
function toggleElement(element) {
  const [row, col, id] = getMaskPointFromElement(element);
  toogleMaskpoint(row, col, id);
}

// Funktion, um aus dem Element die Reihen- und Spaltenwerte zu extrahieren
function getMaskPointFromElement(element) {
  const onclickAttr = element.getAttribute('onchange');
  const regex = /toogleMaskpoint\((\d+),(\d+),(\d+)\)/;
  const match = onclickAttr.match(regex);
  if (match) {
    const row = parseInt(match[1], 10);
    const col = parseInt(match[2], 10);
    const id = parseInt(match[3], 10);
    return [row, col, id];
  }
  return [];
}

