/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import java.util.Vector;
import projektY.base.YException;
import projektY.base.YLookUpDomain;
import projektY.base.YNotFoundException;
import projektY.base.YProgramException;
import projektY.base.YUserException;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDBOChangeEventListener;
import projektY.database.YDatabase;
import projektY.database.YDatabaseData;
import projektY.database.YDatabaseList;
import projektY.database.YDetailList;
import projektY.database.YFieldValue;
import projektY.database.YLookUpDBColumnDefinition;
import projektY.database.YLookUpDomainColumnDefinition;
import projektY.database.YNullValueException;
import projektY.database.YPostListener;
import projektY.database.YRowFkColumnDefinition;
import projektY.database.YRowValues;
import projektY.database.YSession;

public class YRowObject
extends YDatabaseData {
    private YFieldValue pkFieldValue;
    private YRowValues rowValues = new YRowValues(this);
    private Vector<YRowObject> rowObjects = new Vector(5, 5);
    private Vector<YDetailList> detailLists = new Vector(5, 5);
    private Vector<YDetailList> preparedDetailLists = new Vector(5, 5);
    private Vector<YPostListener> postListeners = new Vector(5, 5);
    private YPostListener.PostAction postAction;
    private int idDelete;
    private boolean pkIsFk;
    private boolean createdInsert;
    private boolean requerying;
    MasterLink masterLink;
    private boolean qualifiesMaster;
    private boolean qualifiedMaster;

    public YRowObject(YSession session, int maxFields) throws YProgramException {
        super(session, maxFields);
        this.finalized = false;
        this.qualifiesMaster = false;
        this.qualifiedMaster = false;
        this.requerying = false;
    }

    protected YColumnDefinition addDBField(String fieldName, YColumnDefinition.FieldType fieldType) throws YException {
        YColumnDefinition columnDefinition = this.rowDefinition.addColumnDefinition(fieldName, fieldType, false, false);
        this.rowValues.createDBFieldValue(columnDefinition);
        return columnDefinition;
    }

    protected YColumnDefinition addDatabaseField(String fieldName, YColumnDefinition.FieldType fieldType) throws YException {
        return this.addDBField(fieldName, fieldType);
    }

    protected YRowFkColumnDefinition addFkField(String fieldName, YRowObject referencedObject) throws YException {
        YRowFkColumnDefinition rowFkColumnDefinition = this.rowDefinition.addFkColumnDefinition(fieldName, referencedObject);
        this.rowValues.createDBFieldValue(rowFkColumnDefinition);
        return rowFkColumnDefinition;
    }

    protected YColumnDefinition addROField(String fieldName, YColumnDefinition.FieldType fieldType) throws YException {
        YColumnDefinition columnDefinition = this.rowDefinition.addColumnDefinition(fieldName, fieldType, false, true);
        this.rowValues.createDBFieldValue(columnDefinition);
        return columnDefinition;
    }

    protected YColumnDefinition addReadOnlyField(String fieldName, YColumnDefinition.FieldType fieldType) throws YException {
        return this.addROField(fieldName, fieldType);
    }

    protected void addPkField(String fieldName, boolean pkIsFk) throws YException {
        if (this.pkFieldValue != null) {
            throw new YException("Prim\u00e4rschl\u00fcssel ist nicht eindeutig.");
        }
        YColumnDefinition columnDefinition = this.rowDefinition.addColumnDefinition(fieldName, YColumnDefinition.FieldType.INT, true, false);
        this.rowValues.createDBFieldValue(columnDefinition);
        this.pkFieldValue = this.rowValues.getFieldValue(columnDefinition);
        this.pkIsFk = pkIsFk;
    }

    protected void addPkField(String fieldName, YRowObject rowObject) throws YException {
        if (this.pkFieldValue != null) {
            throw new YException("Prim\u00e4rschl\u00fcssel ist nicht eindeutig.");
        }
        YRowFkColumnDefinition columnDefinition = this.rowDefinition.addPkFkColumnDefinition(fieldName, rowObject);
        this.rowValues.createFkFieldValue(columnDefinition);
        this.pkFieldValue = this.rowValues.getFieldValue(columnDefinition);
        this.pkIsFk = true;
    }

    protected YColumnDefinition addAliasField(String fieldName, YFieldValue aliasValue) throws YException {
        YColumnDefinition aliasDefinition = this.rowDefinition.addAliasDefinition(fieldName, aliasValue.getColumnDefinition());
        this.rowValues.createAliasFieldValue(aliasDefinition, aliasValue);
        return aliasDefinition;
    }

    public YLookUpDBColumnDefinition addLookUpDBField(String fieldName, YDatabaseList lookUpList, String valueFieldName, String altFieldName) throws YException {
        YLookUpDBColumnDefinition lookUpDBColumnDefinition = this.rowDefinition.addLookUpDBColumnDefinition(fieldName, lookUpList, valueFieldName, altFieldName);
        this.rowValues.createLookUpFieldValue(lookUpDBColumnDefinition);
        return lookUpDBColumnDefinition;
    }

    public YLookUpDBColumnDefinition addLookUpDBField(String fieldName, YDatabaseList lookUpList, String valueFieldName) throws YException {
        YLookUpDBColumnDefinition lookUpDBColumnDefinition = this.rowDefinition.addLookUpDBColumnDefinition(fieldName, lookUpList, valueFieldName);
        this.rowValues.createLookUpFieldValue(lookUpDBColumnDefinition);
        return lookUpDBColumnDefinition;
    }

    public YLookUpDomainColumnDefinition addLookUpDomainField(String fieldName, YColumnDefinition.FieldType fieldType, YLookUpDomain domain) throws YException {
        YLookUpDomainColumnDefinition lookUpDomainColumnDefinition = this.rowDefinition.addLookUpDomainDefinition(fieldName, fieldType, domain);
        this.rowValues.createLookUpFieldValue(lookUpDomainColumnDefinition);
        return lookUpDomainColumnDefinition;
    }

    public YLookUpDomainColumnDefinition addLookUpDomainField(String fieldName, YLookUpDomain domain) throws YException {
        YLookUpDomainColumnDefinition lookUpDomainColumnDefinition = this.rowDefinition.addLookUpDomainDefinition(fieldName, domain);
        this.rowValues.createLookUpFieldValue(lookUpDomainColumnDefinition);
        return lookUpDomainColumnDefinition;
    }

    protected void setToStringFields(String[] fieldNames, String concatWith) throws YException {
        int nToStringColumns;
        this.rowDefinition.setToStringFields(fieldNames, concatWith);
        YColumnDefinition[] toStringColumns = this.rowDefinition.toStringColumns;
        int n = nToStringColumns = toStringColumns == null ? 0 : toStringColumns.length;
        if (nToStringColumns > 0) {
            this.rowValues.toStringValues = new YFieldValue[nToStringColumns];
            for (int iCol = 0; iCol < nToStringColumns; ++iCol) {
                this.rowValues.toStringValues[iCol] = this.rowValues.getFieldValue(toStringColumns[iCol]);
            }
        }
    }

    protected void setToStringFields(String[] fieldNames, boolean concat) throws YException {
        int nToStringColumns;
        this.rowDefinition.setToStringFields(fieldNames, concat);
        YColumnDefinition[] toStringColumns = this.rowDefinition.toStringColumns;
        int n = nToStringColumns = toStringColumns == null ? 0 : toStringColumns.length;
        if (nToStringColumns > 0) {
            this.rowValues.toStringValues = new YFieldValue[nToStringColumns];
            for (int iCol = 0; iCol < nToStringColumns; ++iCol) {
                this.rowValues.toStringValues[iCol] = this.rowValues.getFieldValue(toStringColumns[iCol]);
            }
        }
    }

    protected void setToStringFields(String[] fieldNames) throws YException {
        this.setToStringFields(fieldNames, false);
    }

    protected void setToStringField(String fieldName) throws YException {
        this.setToStringFields(new String[]{fieldName}, false);
    }

    public String toString() {
        return this.rowValues.toString();
    }

    public boolean isPkFk() {
        return this.pkIsFk;
    }

    public void setQualifiesMaster(boolean qualifiesMaster) throws YException {
        if (this.masterLink == null) {
            throw new YProgramException(this, "Aufruf von setQualifiesMaster() f\u00fcr " + this.name + " bei nicht vorhandenem masterLink.");
        }
        if (!this.pkIsFk) {
            throw new YProgramException(this, "Aufruf von setQualifiesMaster() f\u00fcr " + this.name + " bei pkIsFk==false.");
        }
        this.qualifiesMaster = qualifiesMaster;
    }

    public boolean qualifiesMaster() throws YProgramException {
        if (this.masterLink == null) {
            throw new YProgramException(this, "Aufruf von qualifiesMaster() f\u00fcr " + this.name + " bei nicht vorhandenem masterLink.");
        }
        return this.qualifiesMaster;
    }

    @Override
    public void addChangeEventListener(YDBOChangeEventListener listener) throws YException {
        super.addChangeEventListener(listener);
        Class<?> superClass = listener.getClass().getSuperclass();
        if (superClass.getName().endsWith("YJRowPanel")) {
            return;
        }
        if ((superClass = superClass.getSuperclass()) != null && superClass.getName().endsWith("YJRowPanel")) {
            return;
        }
        listener.DBObjectChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.ROWSELECTED, 0, this.rowValues));
    }

    public YFieldValue getFieldValue(String fieldName) throws YException {
        return this.rowValues.getFieldValue(fieldName);
    }

    public YFieldValue getPkFieldValue() {
        return this.pkFieldValue;
    }

    public int getPkFieldValueAsInt() throws YProgramException {
        try {
            if (this.pkFieldValue.isNull()) {
                return 0;
            }
            return Integer.parseInt(this.pkFieldValue.toString());
        }
        catch (NumberFormatException e) {
            throw new YProgramException(this, "Ung\u00fcltiger Wert im Prim\u00e4rschl\u00fcssel.");
        }
    }

    public YFieldValue getMasterKeyValue() {
        assert (this.masterLink != null);
        return this.masterLink.fvMasterKey;
    }

    public int getIdDelete() {
        return this.idDelete;
    }

    private void createMasterLink(YRowObject ydroMaster, YFieldValue fvMasterKey) throws YProgramException {
        if (this.masterLink != null) {
            throw new YProgramException(this, "Aufruf von setMasterLink() bei bereits gesetztem MasterLink.");
        }
        this.masterLink = new MasterLink(ydroMaster, fvMasterKey);
    }

    protected void addRowObjectUsingPk(YRowObject rowObject) throws YException {
        if (!(rowObject.isPkFk() ^ this.isPkFk())) {
            throw new YProgramException(this, "addRowObjectUsingPk(): Unzul\u00e4ssige Prim\u00e4rschl\u00fcsselverkn\u00fcpfung");
        }
        int nRowObjects = this.rowObjects.size();
        for (int iRowObject = 0; iRowObject < nRowObjects; ++iRowObject) {
            if (!this.rowObjects.get(iRowObject).getName().equals(rowObject.getName())) continue;
            throw new YProgramException(this, "Ein Zeilenobjekt namens " + rowObject.getName() + " wurde mehr als einmal hinzugef\u00fcgt.");
        }
        this.rowObjects.add(rowObject);
        rowObject.createMasterLink(this, this.getPkFieldValue());
    }

    protected void addDetailRowObject(YRowObject detailRowObject, String fkFieldName) throws YException {
        YRowFkColumnDefinition rowFkColumnDefinition = this.rowDefinition.addFkColumnDefinition(fkFieldName, detailRowObject);
        this.rowValues.createFkFieldValue(rowFkColumnDefinition);
        this.rowObjects.add(detailRowObject);
        detailRowObject.createMasterLink(this, this.getFieldValue(fkFieldName));
    }

    protected void addRowObject(YRowObject rowObject, String fkFieldName) throws YException {
        int nRowObjects = this.rowObjects.size();
        for (int iRowObject = 0; iRowObject < nRowObjects; ++iRowObject) {
            if (!this.rowObjects.get(iRowObject).getName().equals(rowObject.getName())) continue;
            throw new YProgramException(this, "Ein Zeilenobjekt namens " + rowObject.getName() + " wurde mehr als einmal hinzugef\u00fcgt.");
        }
        YRowFkColumnDefinition rowFkColumnDefinition = this.rowDefinition.addFkColumnDefinition(fkFieldName, rowObject);
        this.rowValues.createFkFieldValue(rowFkColumnDefinition);
        this.rowObjects.add(rowObject);
        rowObject.createMasterLink(this, this.getFieldValue(fkFieldName));
    }

    public YRowObject getRowObject(String name) throws YException {
        int nRowObjects = this.rowObjects.size();
        for (int iRowObject = 0; iRowObject < nRowObjects; ++iRowObject) {
            YRowObject rowObject = this.rowObjects.get(iRowObject);
            if (!rowObject.getName().equals(name)) continue;
            return rowObject;
        }
        throw new YProgramException(this, name + " geh\u00f6rt nicht zu diesem Objekt.");
    }

    public YRowObject getDetailRowObject(String name) throws YException {
        return this.getRowObject(name);
    }

    public YDetailList getDetailList(String name) throws YException {
        YDetailList detailList;
        int iDetailList;
        int nDetailLists = this.detailLists.size();
        for (iDetailList = 0; iDetailList < nDetailLists; ++iDetailList) {
            detailList = this.detailLists.get(iDetailList);
            if (!detailList.getName().equals(name)) continue;
            return detailList;
        }
        nDetailLists = this.preparedDetailLists.size();
        for (iDetailList = 0; iDetailList < nDetailLists; ++iDetailList) {
            detailList = this.preparedDetailLists.get(iDetailList);
            if (!detailList.getName().equals(name)) continue;
            if (!this.getPkFieldValue().wasNull()) {
                detailList.fetch();
            }
            this.detailLists.add(detailList);
            this.preparedDetailLists.remove(detailList);
            return detailList;
        }
        throw new YProgramException(this, name + " geh\u00f6rt nicht zu " + (this.name == null ? "diesem Objekt" : this.name) + ".");
    }

    protected void addDetailList(YDetailList detailList) throws YException {
        int iDetailList;
        String listName = detailList.getName();
        if (detailList.getMasterRowObject() != this) {
            throw new YProgramException(this, "Die hinzugef\u00fcgte Detailliste besitzt ein anderes Masterobjekt.");
        }
        int nDetailLists = this.detailLists.size();
        for (iDetailList = 0; iDetailList < nDetailLists; ++iDetailList) {
            if (!this.detailLists.get(iDetailList).getName().equals(listName)) continue;
            throw new YProgramException(this, listName + " wurde doppelt vergeben.");
        }
        nDetailLists = this.preparedDetailLists.size();
        for (iDetailList = 0; iDetailList < nDetailLists; ++iDetailList) {
            if (!this.preparedDetailLists.get(iDetailList).getName().equals(listName)) continue;
            throw new YProgramException(this, listName + " wurde doppelt vergeben.");
        }
        this.detailLists.add(detailList);
    }

    protected void prepareDetailList(YDetailList detailList) throws YException {
        int iDetailList;
        String listName = detailList.getName();
        int nDetailLists = this.detailLists.size();
        for (iDetailList = 0; iDetailList < nDetailLists; ++iDetailList) {
            if (!this.detailLists.get(iDetailList).getName().equals(listName)) continue;
            throw new YProgramException(this, listName + " wurde doppelt vergeben.");
        }
        nDetailLists = this.preparedDetailLists.size();
        for (iDetailList = 0; iDetailList < nDetailLists; ++iDetailList) {
            if (!this.preparedDetailLists.get(iDetailList).getName().equals(listName)) continue;
            throw new YProgramException(this, listName + " wurde doppelt vergeben.");
        }
        this.preparedDetailLists.add(detailList);
    }

    public void addPostListener(YPostListener postListener) {
        assert (this.finalized);
        this.postListeners.add(postListener);
        for (int i = 0; i < this.rowObjects.size(); ++i) {
            this.rowObjects.get(i).addPostListener(postListener);
        }
    }

    @Override
    protected void checkFinalized() throws YProgramException {
        super.checkFinalized();
        if (this.pkFieldValue == null) {
            throw new YProgramException(this, "Der Prim\u00e4rschl\u00fcssel wurde nicht definiert.");
        }
        this.qualifiesMaster = false;
    }

    protected void fireUpdate() throws YException {
        this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, 0, this.rowValues));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchThis(int objId) throws YException {
        block7: {
            try {
                StringBuffer sql = new StringBuffer();
                sql.append(this.sqlSelect);
                sql.append(" WHERE ");
                if (this.tableAlias.length() > 0) {
                    sql.append(this.tableAlias + ".");
                }
                sql.append(this.pkFieldValue.getColumnDefinition().getName());
                sql.append("=");
                sql.append(objId);
                this.sqlQuery.execute(new String(sql));
                if (this.sqlQuery.next()) {
                    this.getQueryResult();
                    if (this.pkIsFk && this.masterLink != null && this.getMasterKeyValue().getColumnDefinition().isPrimaryKey()) {
                        this.qualifiesMaster = true;
                        this.qualifiedMaster = true;
                    }
                    break block7;
                }
                this.clear();
                if (this.pkIsFk && this.masterLink != null && this.getMasterKeyValue().getColumnDefinition().isPrimaryKey()) {
                    this.qualifiesMaster = false;
                    this.qualifiedMaster = false;
                    break block7;
                }
                throw new YNotFoundException("Das Objekt id=" + Integer.toString(objId) + " Tabelle=" + this.tableName + " existiert nicht.");
            }
            finally {
                this.sqlQuery.close();
            }
        }
    }

    public YRowObject fetch(int objId) throws YException {
        int i;
        assert (this.finalized);
        this.fetchThis(objId);
        for (i = 0; i < this.rowObjects.size(); ++i) {
            YFieldValue fkFieldValue;
            YRowObject rowObject = this.rowObjects.get(i);
            if (rowObject.masterLink != null) {
                fkFieldValue = rowObject.masterLink.fvMasterKey;
            } else if (rowObject.isPkFk()) {
                fkFieldValue = this.getPkFieldValue();
            } else {
                throw new YProgramException(this, "Fremdschl\u00fcssel f\u00fcr untergeordnetes YRowObjekt kann nicht ermittelt werden.");
            }
            if (fkFieldValue.isNull()) {
                rowObject.clear();
                continue;
            }
            rowObject.fetch(fkFieldValue.getValueAsInt());
        }
        for (i = 0; i < this.detailLists.size(); ++i) {
            this.detailLists.get(i).fetch();
        }
        this.fireUpdate();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requery() throws YException {
        assert (this.finalized);
        if (!this.pkFieldValue.wasNull()) {
            try {
                this.requerying = true;
                this.fetch(new Integer(this.pkFieldValue.getValue0()));
                for (int i = 0; i < this.detailLists.size(); ++i) {
                    this.detailLists.get(i).fetch();
                }
            }
            finally {
                this.requerying = false;
            }
        }
    }

    public boolean isRequerying() {
        return this.requerying;
    }

    public boolean hasValues() throws YException {
        for (int i = 0; i < this.rowDefinition.getNColumns(); ++i) {
            if (this.rowValues.getFieldValue(i).isAlias() || this.rowValues.getFieldValue(i).isNull()) continue;
            return true;
        }
        return false;
    }

    public boolean hasValuesToStore() {
        return this.rowValues.hasValuesToStore();
    }

    public boolean requestValuesToStore() throws YException {
        this.requestRowValues(this.rowValues);
        return this.rowValues.hasValuesToStore();
    }

    public YRowValues getRowValues() {
        return this.rowValues;
    }

    boolean setDefaults() throws YException {
        boolean defaultsSet = false;
        if (!this.hadPkValue() && this.hasValuesToStore()) {
            for (int iCol = 0; iCol < this.rowDefinition.getNColumns(); ++iCol) {
                defaultsSet |= this.rowValues.getFieldValue(iCol).setDefaultIfNull();
            }
        }
        return defaultsSet;
    }

    public boolean hasNonPkValues() {
        return this.rowValues.hasNonPkValues();
    }

    private boolean hadPkValue() {
        return !this.pkFieldValue.wasNull();
    }

    void postFkNull(YFieldValue fkFieldValue) throws YException {
        if (fkFieldValue == this.pkFieldValue) {
            throw new YProgramException(this, "Der Prim\u00e4rschl\u00fcssel von " + this.tableName + " kann nicht gel\u00f6scht werden.");
        }
        String sql = "UPDATE " + this.tableName + " SET " + fkFieldValue.getColumnDefinition().getName() + "=null WHERE " + this.pkFieldValue.getColumnDefinition().getName() + "=" + this.pkFieldValue.getValue0();
        this.sqlDml.execute(sql);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void postThis() throws YException {
        int i;
        YDatabase database = this.session.getDatabase();
        boolean doDelete = false;
        StringBuffer sql = new StringBuffer();
        int nSqlFields = 0;
        if (this.hadPkValue()) {
            if (this.rowValues.hasValuesToStore() || this.pkIsFk && !this.pkFieldValue.isNull()) {
                sql.append("UPDATE " + this.tableName + " SET ");
                this.postAction = YPostListener.PostAction.UPDATE;
                for (i = 0; i < this.rowDefinition.getNColumns(); ++i) {
                    if (this.rowValues.getFieldValue(i).isAlias() || this.rowValues.getFieldValue(i).getColumnDefinition().isPrimaryKey() || this.rowValues.getFieldValue(i).getColumnDefinition().isReadOnly() || this.rowValues.getFieldValue(i).getColumnDefinition().isEmpty() || !this.rowValues.getFieldValue(i).hasChanged()) continue;
                    if (nSqlFields > 0) {
                        sql.append(", ");
                    }
                    sql.append(this.rowValues.getFieldValue(i).getColumnDefinition().getName() + "=");
                    sql.append(this.sqlValue(this.rowValues.getFieldValue(i)));
                    ++nSqlFields;
                }
                if (nSqlFields == 0) {
                    return;
                }
                this.rowValues.setPostMark();
            } else {
                if (this.masterLink != null) {
                    if (!database.isInTransaction()) {
                        database.startTransaction();
                    }
                    if (!this.masterLink.isLinkedWithPk()) {
                        this.masterLink.postMasterFkNull();
                    }
                }
                sql.append("DELETE FROM " + this.tableName);
                this.postAction = YPostListener.PostAction.DELETE;
                this.idDelete = this.getPkFieldValueAsInt();
                this.pkFieldValue.modifyValue("");
                doDelete = true;
                this.rowValues.setDeleteMark();
            }
            sql.append(" WHERE " + this.pkFieldValue.getColumnDefinition().getName() + "=" + this.pkFieldValue.getValue0());
        } else {
            if (!this.pkIsFk) {
                if (!this.rowValues.hasValuesToStore()) {
                    return;
                }
            } else if (this.pkFieldValue.isNull()) {
                if (this.masterLink != null && this.masterLink.isLinkedWithPk()) {
                    if (this.rowValues.hasValuesToStore()) {
                        this.qualifiesMaster = true;
                    }
                    if (!this.qualifiesMaster) return;
                    this.pkFieldValue.modifyValue(this.masterLink.fvMasterKey.getValue());
                } else {
                    if (!this.rowValues.hasValuesToStore()) return;
                    throw new YProgramException(this, "Prim\u00e4rschl\u00fcssel kann nicht beschafft werden.");
                }
            }
            if (!database.isInTransaction()) {
                database.startTransaction();
            }
            if (!this.pkIsFk) {
                int nextId = database.nextId(this.tableName);
                this.pkFieldValue.setAutoId(nextId);
            }
            StringBuffer sql2 = new StringBuffer();
            sql.append("INSERT INTO " + this.tableName + "(");
            sql2.append(" VALUES (");
            this.postAction = YPostListener.PostAction.INSERT;
            for (i = 0; i < this.rowDefinition.getNColumns(); ++i) {
                String value;
                if (this.rowValues.getFieldValue(i).isAlias() || this.rowValues.getFieldValue(i).getColumnDefinition().isReadOnly() || this.rowValues.getFieldValue(i).getColumnDefinition().isEmpty() || (value = this.rowValues.getFieldValue(i).getValue()).length() <= 0) continue;
                if (nSqlFields > 0) {
                    sql.append(", ");
                    sql2.append(", ");
                }
                sql.append(this.rowValues.getFieldValue(i).getColumnDefinition().getName());
                sql2.append(this.sqlValue(this.rowValues.getFieldValue(i)));
                ++nSqlFields;
            }
            sql.append(")" + sql2 + ")");
            this.createdInsert = true;
            this.rowValues.setPostMark();
        }
        if (!database.isInTransaction()) {
            database.startTransaction();
        }
        this.sqlDml.execute(new String(sql));
        if (doDelete) {
            for (i = 0; i < this.rowDefinition.getNColumns(); ++i) {
                YFieldValue fieldValue = this.rowValues.getFieldValue(i);
                if (fieldValue.isAlias()) continue;
                if (fieldValue.getColumnDefinition().isReadOnly()) {
                    fieldValue.setROValue("");
                    continue;
                }
                fieldValue.modifyValue("");
            }
            return;
        } else {
            if (this.masterLink == null || !this.pkFieldValue.hasChanged()) return;
            this.masterLink.modifyMasterKeyValue(this.pkFieldValue.getValue());
        }
    }

    protected void unsetPosted() throws YException {
        int i;
        for (i = 0; i < this.rowObjects.size(); ++i) {
            this.rowObjects.get(i).unsetPosted();
        }
        this.rowValues.resetMarks();
        for (i = 0; i < this.detailLists.size(); ++i) {
            this.detailLists.get(i).unsetPosted();
        }
    }

    protected void setPosted() throws YException {
        int i;
        for (i = 0; i < this.rowObjects.size(); ++i) {
            this.rowObjects.get(i).setPosted();
        }
        this.rowValues.setPosted();
        for (i = 0; i < this.detailLists.size(); ++i) {
            if (!this.detailLists.get(i).setPosted()) continue;
            this.detailLists.get(i).fireChanged(new YDBOChangeEvent());
        }
        this.qualifiedMaster = this.qualifiesMaster;
        for (i = 0; i < this.postListeners.size(); ++i) {
            this.postListeners.get(i).rowObjectPosted(this, this.postAction);
        }
    }

    protected void beforeBegin() throws YException {
    }

    protected void afterBegin() throws YException {
    }

    protected void beforeCommit() throws YException {
    }

    private void updateFkValues(YDatabaseData referencedObject) throws YException {
        if (this.pkFieldValue.isNull()) {
            return;
        }
        StringBuffer sql = new StringBuffer(40);
        for (int iCol = 0; iCol < this.rowDefinition.getNColumns(); ++iCol) {
            YFieldValue pkValue;
            YColumnDefinition columnDefinition = this.rowDefinition.getColumnDefinition(iCol);
            if (!columnDefinition.isRowFk()) continue;
            YRowFkColumnDefinition rowFkColumnDefinition = (YRowFkColumnDefinition)columnDefinition;
            YFieldValue fkValue = this.getFieldValue(columnDefinition.getName());
            if (!fkValue.isNull() || referencedObject != null && rowFkColumnDefinition.getReferencedObject() != referencedObject || (pkValue = rowFkColumnDefinition.getReferencedObject().getPkFieldValue()).isNull() || fkValue.getValue().equals(pkValue.getValue())) continue;
            fkValue.modifyValue(pkValue.getValue());
            if (sql.length() > 0) {
                sql.append(", ");
            }
            sql.append(rowFkColumnDefinition.getName() + "=" + fkValue.getValue());
        }
        if (sql.length() > 0) {
            sql.insert(0, "UPDATE " + this.tableName + " SET ");
            sql.append(" WHERE " + this.pkFieldValue.getColumnDefinition().getName() + "=" + this.pkFieldValue.getValue());
            this.sqlDml.execute(sql.toString());
        }
        if (referencedObject != null) {
            for (int iRObj = 0; iRObj < this.rowObjects.size(); ++iRObj) {
                this.rowObjects.get(iRObj).updateFkValues(referencedObject);
            }
        }
    }

    protected void checkNotNull() throws YNullValueException, YException {
        int nCols = this.rowDefinition.getNColumns();
        if (!this.rowValues.hasValuesToStore()) {
            return;
        }
        for (int iCol = 0; iCol < nCols; ++iCol) {
            YColumnDefinition columnDefinition;
            YFieldValue fieldValue = this.rowValues.getFieldValue(iCol);
            if (fieldValue == this.pkFieldValue || (columnDefinition = fieldValue.getColumnDefinition()).isReadOnly() || !fieldValue.isNull() || !columnDefinition.isNotNull()) continue;
            throw new YNullValueException(this.getLabel(), columnDefinition.getLabel());
        }
    }

    public void post() throws YException {
        int i;
        assert (this.finalized);
        YDatabase database = this.session.getDatabase();
        boolean wasInTransaction = database.isInTransaction();
        boolean defaultsSet = false;
        this.requestRowValues(this.rowValues);
        this.beforeBegin();
        if (!wasInTransaction) {
            defaultsSet = this.setDefaults();
            for (i = 0; i < this.rowObjects.size(); ++i) {
                defaultsSet |= this.rowObjects.get(i).setDefaults();
            }
            for (i = 0; i < this.detailLists.size(); ++i) {
                defaultsSet |= this.detailLists.get(i).setDefaults();
            }
            this.checkNotNull();
            for (i = 0; i < this.rowObjects.size(); ++i) {
                this.rowObjects.get(i).checkNotNull();
            }
            for (i = 0; i < this.detailLists.size(); ++i) {
                this.detailLists.get(i).checkNotNull();
            }
        }
        try {
            if (!database.isInTransaction()) {
                database.startTransaction();
            }
            this.afterBegin();
            for (i = 0; i < this.rowObjects.size(); ++i) {
                if (this.rowObjects.get(i).isPkFk()) continue;
                this.rowObjects.get(i).post();
            }
            this.createdInsert = false;
            this.postThis();
            for (i = 0; i < this.rowObjects.size(); ++i) {
                if (!this.rowObjects.get(i).isPkFk()) continue;
                this.rowObjects.get(i).post();
            }
            if (this.pkFieldValue.isNull()) {
                if (this.pkFieldValue.wasNull()) {
                    for (i = 0; i < this.detailLists.size(); ++i) {
                        if (!this.detailLists.get(i).hasRowsToStore()) continue;
                        throw new YException("Details zu einem leeren Objekt k\u00f6nnen nicht gespeichert werden.");
                    }
                } else {
                    for (i = 0; i < this.detailLists.size(); ++i) {
                        this.detailLists.get(i).clear();
                    }
                }
            } else {
                int iPk = new Integer(this.pkFieldValue.getValue());
                for (i = 0; i < this.detailLists.size(); ++i) {
                    YDetailList detailList = this.detailLists.get(i);
                    if (detailList.isReadOnly()) continue;
                    if (detailList.getRowObjectId() == 0) {
                        detailList.setAutoRowObjectId(iPk);
                    } else assert (iPk == detailList.getRowObjectId());
                    detailList.post();
                }
            }
            if (this.createdInsert) {
                this.updateFkValues(null);
                for (i = 0; i < this.rowObjects.size(); ++i) {
                    this.rowObjects.get(i).updateFkValues(this);
                }
            }
            this.beforeCommit();
            if (!wasInTransaction && database.isInTransaction()) {
                database.commit();
                this.setPosted();
                if (defaultsSet) {
                    this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, 0, this.rowValues));
                }
            }
        }
        catch (YException e) {
            if (!wasInTransaction && database.isInTransaction()) {
                database.rollback();
                this.unsetPosted();
            }
            throw e;
        }
    }

    public boolean belongsToMe(YRowObject rowObject) {
        for (int i = 0; i < this.rowObjects.size(); ++i) {
            if (rowObject != this.rowObjects.get(i)) continue;
            return true;
        }
        return false;
    }

    public void qualifyAs(YRowObject qualifier) throws YException {
        assert (this.finalized);
        if (!this.belongsToMe(qualifier)) {
            throw new YProgramException(this, "qualifyAs() zu fremdem Objekt ist nicht m\u00f6glich.");
        }
        if (!qualifier.isPkFk()) {
            throw new YProgramException(this, "Aufruf von qualifyAs() mit einem nicht qualifizierenden Objekt.");
        }
        qualifier.revert();
        qualifier.setQualifiesMaster(true);
    }

    public void disqualifyFrom(YRowObject qualifier) throws YException {
        assert (this.finalized);
        if (!this.belongsToMe(qualifier)) {
            throw new YProgramException(this, "disqualifyFrom() bei fremdem Objekt ist nicht m\u00f6glich.");
        }
        if (!qualifier.isPkFk()) {
            throw new YProgramException(this, "Aufruf von disqualifyFrom() mit einem nicht qualifizierenden Objekt.");
        }
        qualifier.setQualifiesMaster(false);
        qualifier.modifyToNull();
    }

    public boolean isQualifiedAs(YRowObject qualifier) throws YException {
        assert (this.finalized);
        if (!this.belongsToMe(qualifier)) {
            throw new YProgramException(this, "isQualifiedAs() bei fremdem Objekt ist nicht m\u00f6glich.");
        }
        if (!qualifier.isPkFk()) {
            throw new YProgramException(this, "Aufruf von isQualifiedAs() mit einem nicht qualifizierenden Objekt.");
        }
        return qualifier.qualifiesMaster;
    }

    public void delete() throws YException {
        assert (this.finalized);
        if (this.pkFieldValue.getValue0().length() == 0) {
            throw new YUserException("Es gibt nichts zu l\u00f6schen.");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM " + this.tableName + " WHERE " + this.pkFieldValue.getColumnDefinition().getName() + "=" + this.pkFieldValue.getValue0());
        this.postAction = YPostListener.PostAction.DELETE;
        this.idDelete = Integer.parseInt(this.pkFieldValue.getValue0());
        YDatabase database = this.session.getDatabase();
        boolean wasInTransaction = database.isInTransaction();
        try {
            if (!wasInTransaction) {
                database.startTransaction();
            }
            if (this.masterLink != null) {
                this.masterLink.postMasterFkNull();
            }
            this.sqlDml.execute(new String(sql));
            if (!wasInTransaction && database.isInTransaction()) {
                database.commit();
            }
            this.clear();
            for (int i = 0; i < this.postListeners.size(); ++i) {
                this.postListeners.get(i).rowObjectPosted(this, this.postAction);
            }
        }
        catch (YException e) {
            if (!wasInTransaction && database.isInTransaction()) {
                database.rollback();
            }
            throw e;
        }
    }

    public void revert() throws YException {
        int i;
        this.rowValues.revert();
        for (i = 0; i < this.rowObjects.size(); ++i) {
            this.rowObjects.get(i).revert();
        }
        for (i = 0; i < this.detailLists.size(); ++i) {
            this.detailLists.get(i).revert();
        }
        this.qualifiesMaster = this.qualifiedMaster;
        this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, 0, this.rowValues));
    }

    public void clear() throws YException {
        int i;
        this.rowValues.clear();
        for (i = 0; i < this.rowObjects.size(); ++i) {
            this.rowObjects.get(i).clear();
        }
        for (i = 0; i < this.detailLists.size(); ++i) {
            this.detailLists.get(i).clear();
        }
        this.qualifiesMaster = false;
        this.qualifiedMaster = false;
        this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, 0, this.rowValues));
    }

    public void modifyThisToNull() throws YException {
        this.rowValues.modifyThisToNull();
    }

    public void modifyToNull() throws YException {
        this.rowValues.modifyToNull();
    }

    public void modifyAllToNull() throws YException {
        this.modifyToNull();
        for (int i = 0; i < this.rowObjects.size(); ++i) {
            this.rowObjects.get(i).modifyAllToNull();
        }
    }

    void getQueryResult() throws YException {
        for (int i = 0; i < this.rowDefinition.getNColumns(); ++i) {
            this.getQueryResult(this.rowValues.getFieldValue(i));
        }
        if (this.masterLink != null) {
            this.masterLink.modifyMasterKeyValue(this.pkFieldValue.getValue());
        }
    }

    Vector<YRowObject> getRowobjects() {
        return this.rowObjects;
    }

    public void setAsString(String fieldName, String value) throws YException {
        this.rowValues.setAsString(fieldName, value);
    }

    public void setAsInt(String fieldName, int value) throws YException {
        this.rowValues.setAsInt(fieldName, value);
    }

    public void setAsBool(String fieldName, boolean value) throws YException {
        this.rowValues.setAsBool(fieldName, value);
    }

    public void setAsFloat(String fieldName, float value) throws YException {
        this.modifyFieldValue(this.rowValues.getFieldValue(fieldName), value);
    }

    public void setNull(String fieldName) throws YException {
        this.modifyToNull(fieldName);
    }

    public void modifyToNull(String fieldName) throws YException {
        this.rowValues.getFieldValue(fieldName).modifyToNull();
    }

    public void setFromRow(String fieldName, Object rowValues, String rowFieldName) throws YException {
        this.rowValues.setFromRow(fieldName, rowValues, rowFieldName);
    }

    public String getAsString(String fieldName) throws YException {
        return this.rowValues.getAsString(fieldName);
    }

    public int getAsInt(String fieldName) throws YException {
        return this.rowValues.getAsInt(fieldName);
    }

    public int getAsInt(String fieldName, int ifNull) throws YException {
        return this.rowValues.getAsInt(fieldName, ifNull);
    }

    public boolean getAsBool(String fieldName) throws YException {
        return this.rowValues.getAsBool(fieldName);
    }

    public boolean getAsBool(String fieldName, boolean ifNull) throws YException {
        return this.rowValues.getAsBool(fieldName, ifNull);
    }

    public float getAsFloat(String fieldName) throws YException {
        YFieldValue fv = this.getFieldValue(fieldName);
        try {
            return this.parseFloat(fv);
        }
        catch (NumberFormatException e) {
            throw new YProgramException(this, "'" + fv.getValue() + "' ist kein g\u00fcltiger Gleitkommawert.");
        }
    }

    public float getAsFloat(String fieldName, float ifNull) throws YException {
        YFieldValue fv = this.getFieldValue(fieldName);
        if (fv.isNull()) {
            return ifNull;
        }
        try {
            return this.parseFloat(fv);
        }
        catch (NumberFormatException e) {
            throw new YProgramException(this, "'" + fv.getValue() + "' ist kein g\u00fcltiger Gleitkommawert.");
        }
    }

    public void assign(YRowObject rowObject) throws YException {
        this.assign(this.rowValues, rowObject);
    }

    public boolean hasChanged() throws YException {
        int i;
        this.requestRowValues(this.rowValues);
        if (this.rowValues.hasChanged()) {
            this.lastHasChanged = this.getName() + " " + this.rowValues.coldefChanged.getName() + ": '" + this.rowValues.fieldValueChanged.getValue0() + "' -> '" + this.rowValues.fieldValueChanged.getValue() + "'";
            return true;
        }
        for (i = 0; i < this.rowObjects.size(); ++i) {
            if (!this.rowObjects.get(i).hasChanged()) continue;
            this.lastHasChanged = this.detailLists.get(i).getLastHasChanged();
            return true;
        }
        for (i = 0; i < this.detailLists.size(); ++i) {
            if (!this.detailLists.get(i).hasChanged()) continue;
            this.lastHasChanged = this.detailLists.get(i).getLastHasChanged();
            return true;
        }
        if (this.lastHasChanged.length() > 0) {
            this.lastHasChanged = "";
        }
        return false;
    }

    class MasterLink {
        private YRowObject ydroMaster;
        private YFieldValue fvMasterKey;

        MasterLink(YRowObject ydroMaster, YFieldValue fvMasterKey) throws YProgramException {
            YColumnDefinition masterKeyDefinition = fvMasterKey.getColumnDefinition();
            if (!masterKeyDefinition.isPrimaryKey() && !masterKeyDefinition.isForeignKey()) {
                throw new YProgramException(this, masterKeyDefinition.getName() + " kann keine Verkn\u00fcpfung definieren, weil es kein Schl\u00fcsselfeld ist.");
            }
            this.ydroMaster = ydroMaster;
            this.fvMasterKey = fvMasterKey;
        }

        public void postMasterFkNull() throws YException {
            this.ydroMaster.postFkNull(this.fvMasterKey);
        }

        public void modifyMasterKeyValue(String value) throws YException {
            this.fvMasterKey.modifyValue(value);
        }

        public boolean wasMasterKeyValueNull() throws YProgramException {
            return this.fvMasterKey.wasNull();
        }

        public boolean isLinkedWith(YFieldValue fieldValue) {
            return fieldValue == this.fvMasterKey;
        }

        public boolean isLinkedWithPk() {
            return this.ydroMaster.getPkFieldValue() == this.fvMasterKey;
        }
    }
}

