/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YDetailList;
import projektY.database.YPosDetailListManager;
import projektY.database.YRowObject;
import projektY.database.YSession;
import projektY.database.YSubDetailList;

public class YSubPosDetailList
extends YSubDetailList {
    protected YPosDetailListManager posDetailListManager;
    protected YDetailList detailList;

    public YSubPosDetailList(YSession session, int maxColumns, YDetailList detailList) throws YException {
        super(session, maxColumns, detailList, detailList.masterRowObject);
        this.detailList = detailList;
        this.posDetailListManager = new YPosDetailListManager(this);
    }

    public YSubPosDetailList(YSession session, int maxColumns, YDetailList detailList, YRowObject masterRowObject) throws YException {
        super(session, maxColumns, detailList, masterRowObject);
        this.detailList = detailList;
        this.posDetailListManager = new YPosDetailListManager(this);
    }

    public YSubPosDetailList(YSession session, int maxColumns, YDetailList detailList, int masterId) throws YException {
        super(session, maxColumns, detailList, masterId);
        this.detailList = detailList;
        this.posDetailListManager = new YPosDetailListManager(this);
    }

    protected YColumnDefinition addPosField(String fieldName) throws YException {
        return this.posDetailListManager.addPosField(fieldName);
    }

    @Override
    protected void checkFinalized() throws YProgramException {
        super.checkFinalized();
        this.posDetailListManager.checkFinalized();
        String masterFkName = this.rowObjectFkAlias == null ? this.masterRowFkDefinition.getName() : this.rowObjectFkAlias + this.masterRowFkDefinition.getName();
        this.setOrder(new String[]{masterFkName, this.posDetailListManager.posDefinition.getName()});
    }

    @Override
    public void setOrder(String[] order, boolean desc) throws YProgramException {
        if (this.finalized) {
            throw new YProgramException(this, "Die Sortierung bei YSubPosList wird automatisch gesetzt und darf nicht ge\u00e4ndert werden.");
        }
        super.setOrder(order, desc);
    }

    @Override
    public void post() throws YException {
        int nRows = this.detailList.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            this.setSubWindow(this.detailList.getRowId(iRow));
            this.posDetailListManager.renumber();
        }
        super.post();
    }

    @Override
    public int moveUp(int iRow) throws YException {
        this.posDetailListManager.exchangePosUp(iRow);
        return super.moveUp(iRow);
    }

    @Override
    public int moveDown(int iRow) throws YException {
        this.posDetailListManager.exchangePosDown(iRow);
        return super.moveDown(iRow);
    }

    @Override
    public void revert() throws YException {
        super.revert();
        if (this.hasSubWindow()) {
            int detailRowId = this.getDetailRowId();
            int nRows = this.detailList.getRowCount();
            for (int iRow = 0; iRow < nRows; ++iRow) {
                this.setSubWindow(this.detailList.getRowValues(iRow).getRowId());
                this.posDetailListManager.reSort();
            }
            this.setSubWindow(detailRowId);
        }
    }
}

