/*
 * Decompiled with CFR 0.152.
 */
package projektY.database.jLibY;

import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDatabaseList;
import projektY.database.YRowValues;
import projektY.database.YSession;

public class YParamDBList
extends YDatabaseList {
    private String paramNameObjId = null;

    protected YParamDBList(YSession session, int maxColumns) throws YException {
        super(session, maxColumns);
    }

    protected YParamDBList(YSession session) throws YException {
        this(session, 0);
    }

    protected void setObjIdField(String fieldName) throws YException {
        if (this.paramNameObjId != null) {
            throw new YProgramException(this, "Das ObjIdFeld wurde mehrfach festgelegt.");
        }
        this.paramNameObjId = fieldName;
    }

    protected YColumnDefinition addObjIdField(String fieldName) throws YException {
        this.setObjIdField(fieldName);
        return super.addDBField(fieldName, YColumnDefinition.FieldType.INT);
    }

    @Override
    protected void checkFinalized() throws YProgramException {
        super.checkFinalized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public YDatabaseList fetch() throws YException {
        int nFetched = 0;
        try {
            this.beginNestedChange();
            StringBuffer sql = new StringBuffer(this.paramSelect.createSQL(this));
            this.unsetActiveRow();
            if (this.order != null) {
                sql.append(" ORDER BY ");
                for (int i = 0; i < this.order.length; ++i) {
                    if (i > 0) {
                        sql.append(", ");
                    }
                    sql.append(this.order[i]);
                }
                if (this.orderDesc) {
                    sql.append(" DESC");
                }
            }
            this.sqlQuery.execute(sql.toString());
            this.clearRowValues();
            this.moreRows = false;
            while (this.sqlQuery.next()) {
                if (this.maxRows > 0 && ++nFetched > this.maxRows) {
                    this.moreRows = true;
                    break;
                }
                YRowValues rowValues = this.createRowValues();
                for (int i = 0; i < this.rowDefinition.getNColumns(); ++i) {
                    this.getQueryResult(rowValues.getFieldValue(i));
                }
                this.addRowValues(rowValues);
            }
            YParamDBList yParamDBList = this;
            return yParamDBList;
        }
        finally {
            this.sqlQuery.close();
            this.endNestedChange();
            this.fireChanged(new YDBOChangeEvent());
        }
    }

    public YDatabaseList fetch(int objId) throws YException {
        if (this.paramNameObjId == null) {
            throw new YProgramException(this, "fetch(objId) ohne addObjIdField().");
        }
        this.paramSelect.setParamValue(this.paramNameObjId, String.valueOf(objId));
        return this.fetch();
    }
}

