/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YProgramException;

public class YColumnDefinition {
    private FieldType fieldType;
    private String name;
    private String label;
    private String dflt;
    private boolean primaryKey;
    private boolean readOnly;
    private String numFormat;
    private int notNullCondition;
    public static final int NULL_ALLOWED = 0;
    public static final int NOT_NULL = 1;
    public static final int REQUIRED = 2;
    private YColumnDefinition aliasFor;
    boolean visible;
    int fieldValueIndex;
    private int columnId;

    public YColumnDefinition(String name, FieldType fieldType, boolean primaryKey, boolean readOnly) {
        this.fieldValueIndex = -1;
        this.name = name;
        this.label = name;
        this.dflt = null;
        this.fieldType = fieldType;
        this.primaryKey = primaryKey;
        this.readOnly = readOnly;
        this.notNullCondition = 0;
        this.aliasFor = null;
        this.visible = false;
        this.columnId = 0;
    }

    public YColumnDefinition(int fieldValueIndex, String name, FieldType fieldType, boolean primaryKey, boolean readOnly) {
        this.fieldValueIndex = fieldValueIndex;
        this.name = name;
        this.label = name;
        this.dflt = null;
        this.fieldType = fieldType;
        this.primaryKey = primaryKey;
        this.readOnly = readOnly;
        this.notNullCondition = 0;
        this.aliasFor = null;
        this.visible = false;
        this.columnId = 0;
    }

    public YColumnDefinition(int fieldValueIndex, String name, YColumnDefinition columnDefinition) {
        this.fieldValueIndex = fieldValueIndex;
        this.name = name;
        this.primaryKey = false;
        this.label = columnDefinition.getLabel();
        this.dflt = columnDefinition.getDefault();
        this.fieldType = columnDefinition.getFieldType();
        this.readOnly = columnDefinition.isReadOnly();
        this.notNullCondition = 0;
        this.numFormat = columnDefinition.getNumFormat();
        this.aliasFor = columnDefinition;
        this.visible = false;
        this.columnId = 0;
    }

    public final void setFieldValueIndex(int fieldValueIndex) throws YProgramException {
        if (this.fieldValueIndex >= 0) {
            throw new YProgramException(this, "fielValueIndex von " + this.name + " ist bereits gesetzt.");
        }
        this.fieldValueIndex = fieldValueIndex;
    }

    public final int getFieldValueIndex() {
        return this.fieldValueIndex;
    }

    public final int getColumnId() {
        return this.columnId;
    }

    public final void setColumnId(int columnId) {
        this.columnId = columnId;
    }

    public final String getName() {
        return this.name;
    }

    public final FieldType getFieldType() {
        return this.fieldType;
    }

    public boolean isAlias() {
        return this.aliasFor != null;
    }

    public YColumnDefinition getAliasFor() {
        if (this.isAlias()) {
            return this.aliasFor;
        }
        return null;
    }

    public YColumnDefinition getRootDefinition() {
        if (this.isAlias()) {
            return this.aliasFor.getRootDefinition();
        }
        return this;
    }

    public String toString() {
        return this.label;
    }

    public final boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isLookUp() {
        return false;
    }

    public boolean isDomain() {
        return false;
    }

    public boolean isRowFk() {
        return false;
    }

    public boolean isListFk() {
        return false;
    }

    public boolean isForeignKey() {
        return this.isRowFk() || this.isListFk();
    }

    public boolean isCheck() {
        return false;
    }

    public void setVisible() {
        this.visible = true;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public final YColumnDefinition setReadOnly() {
        this.readOnly = true;
        return this;
    }

    public final YColumnDefinition setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final YColumnDefinition setLabel(String label) {
        this.label = label;
        return this;
    }

    public final String getLabel() {
        return this.label;
    }

    public final YColumnDefinition setDefault(String dflt) throws YProgramException {
        if (this.isPrimaryKey() || this.isReadOnly()) {
            throw new YProgramException(this, "Prim\u00e4rschl\u00fcssel und ReadOnly-Felder k\u00f6nnen keinen Default haben.");
        }
        this.dflt = dflt;
        return this;
    }

    public String getDefault() {
        return this.dflt;
    }

    public boolean equals(YColumnDefinition columnDefinition) {
        if (!columnDefinition.getName().equals(this.name)) {
            return false;
        }
        return columnDefinition.getFieldType() == this.fieldType;
    }

    public YColumnDefinition setNumFormat(String numFormat) {
        this.numFormat = numFormat;
        return this;
    }

    protected String getNumFormat() {
        return this.numFormat;
    }

    public YColumnDefinition setNotNull(int notNullCondition) {
        assert (notNullCondition >= 0);
        this.notNullCondition = notNullCondition;
        return this;
    }

    public YColumnDefinition setNotNull(boolean notNull) {
        this.notNullCondition = notNull ? 1 : 0;
        return this;
    }

    public YColumnDefinition setNotNull() {
        this.notNullCondition = 1;
        return this;
    }

    public boolean isNotNull() {
        return this.notNullCondition == 1;
    }

    public boolean isAlwaysReqired() {
        return this.notNullCondition == 1 || this.notNullCondition == 2;
    }

    public boolean isReqired() {
        return this.notNullCondition > 0;
    }

    public int getNotNullCondition() {
        return this.notNullCondition;
    }

    public boolean isAnInt() {
        return this.fieldType.equals((Object)FieldType.INT) || this.fieldType.equals((Object)FieldType.SHORT) || this.fieldType.equals((Object)FieldType.LONG) || this.fieldType.equals((Object)FieldType.EMPTYINT);
    }

    public boolean isEmpty() {
        return this.fieldType.equals((Object)FieldType.EMPTYSTRING) || this.fieldType.equals((Object)FieldType.EMPTYINT) || this.fieldType.equals((Object)FieldType.EMPTYFLOAT) || this.fieldType.equals((Object)FieldType.EMPTYBOOLEAN);
    }

    public boolean isAFloat() {
        return this.fieldType.equals((Object)FieldType.FLOAT) || this.fieldType.equals((Object)FieldType.DOUBLE) || this.fieldType.equals((Object)FieldType.EMPTYFLOAT);
    }

    public boolean isANum() {
        return this.isAnInt() || this.isAFloat();
    }

    public static enum FieldType {
        BOOLEAN,
        DOUBLE,
        FLOAT,
        INT,
        LONG,
        SHORT,
        STRING,
        DATE,
        TIME,
        TIMESTAMP,
        EMPTYSTRING,
        EMPTYINT,
        EMPTYFLOAT,
        EMPTYBOOLEAN;

    }
}

