/*
 * Decompiled with CFR 0.152.
 */
package velometrikLAF.painters;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import velometrikLAF.VelometrikGraphicsUtils;

public class TreePainter
extends SynthPainter {
    private static Icon expandedTreeIcon;
    private static Icon collapsedTreeIcon;

    public TreePainter() {
        UIManager.put("Tree.leafIcon", new ImageIcon("velometrikLAF/icons/TreeLeaf.gif"));
        UIManager.put("Tree.openIcon", new ImageIcon("velometrikLAF/icons/TreeOpen.gif"));
        UIManager.put("Tree.closedIcon", new ImageIcon("velometrikLAF/icons/TreeClosed.gif"));
        UIManager.put("Tree.expandedIcon", new ImageIcon("velometrikLAF/icons/TreeOpen.gif"));
        UIManager.put("Tree.collapsedIcon", new ImageIcon("velometrikLAF/icons/TreeClosed.gif"));
    }

    static Icon getExpandedTreeIcon() {
        if (expandedTreeIcon == null) {
            expandedTreeIcon = new ExpandedTreeIcon();
        }
        return expandedTreeIcon;
    }

    static Icon getCollapsedTreeIcon() {
        if (collapsedTreeIcon == null) {
            collapsedTreeIcon = new CollapsedTreeIcon();
        }
        return collapsedTreeIcon;
    }

    @Override
    public void paintTreeCellBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        g.setColor(VelometrikGraphicsUtils.getWebColor("950000"));
        g.fillRect(x, y, w, h);
    }

    @Override
    public void paintTreeCellBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        g.setColor(VelometrikGraphicsUtils.getWebColor("950000"));
        g.fillRect(x, y, w, h);
    }

    private static class CollapsedTreeIcon
    extends ExpandedTreeIcon {
        private CollapsedTreeIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            g.drawLine(x + 4, y + 2, x + 4, y + 6);
        }
    }

    private static class ExpandedTreeIcon
    implements Icon,
    Serializable {
        protected static final int SIZE = 9;
        protected static final int HALF_SIZE = 4;

        private ExpandedTreeIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.WHITE);
            g.fillRect(x, y, 8, 8);
            g.setColor(Color.GRAY);
            g.drawRect(x, y, 8, 8);
            g.setColor(Color.BLACK);
            g.drawLine(x + 2, y + 4, x + 6, y + 4);
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public int getIconHeight() {
            return 9;
        }
    }
}

