/*
 * Decompiled with CFR 0.152.
 */
package projektY.base;

import projektY.base.YLookUpValue;
import projektY.base.YProgramException;

public class YLookUpDomain {
    private YLookUpValue[] lookUpValues;

    public YLookUpDomain(YLookUpValue[] lookUpValues) {
        this.lookUpValues = lookUpValues;
    }

    public YLookUpDomain(String[] domainValues) {
        this.lookUpValues = new YLookUpValue[domainValues.length];
        for (int i = 0; i < this.lookUpValues.length; ++i) {
            this.lookUpValues[i] = new YLookUpValue(domainValues[i], domainValues[i]);
        }
    }

    public int getValueCount() {
        return this.lookUpValues.length;
    }

    public YLookUpValue getLookUpObject(int iValue) throws YProgramException {
        try {
            return this.lookUpValues[iValue];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, e.getMessage());
        }
    }

    public String getValue(int iValue) throws YProgramException {
        try {
            return this.lookUpValues[iValue].getValue();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, e.getMessage());
        }
    }

    public String getLookUpValue(int iValue) throws YProgramException {
        try {
            return this.lookUpValues[iValue].toString();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, e.getMessage());
        }
    }

    public YLookUpValue lookUpObject(String value) {
        for (int i = 0; i < this.lookUpValues.length; ++i) {
            if (!this.lookUpValues[i].getValue().equals(value)) continue;
            return this.lookUpValues[i];
        }
        return null;
    }

    public YLookUpValue lookUpObject(int value) {
        return this.lookUpObject(String.valueOf(value));
    }

    public String lookUp(String value) {
        for (int i = 0; i < this.lookUpValues.length; ++i) {
            if (!this.lookUpValues[i].getValue().equals(value)) continue;
            return this.lookUpValues[i].toString();
        }
        return "";
    }

    public String lookUp(int value) {
        return this.lookUp(String.valueOf(value));
    }
}

