/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YDetailList;
import projektY.database.YLinkedDetailList;
import projektY.database.YNullValueException;
import projektY.database.YRowObject;
import projektY.database.YRowValues;
import projektY.database.YSession;
import projektY.database.YSubDetailListImplementation;
import projektY.database.YSubDetailListManager;

public class YLinkedSubDetailList
extends YLinkedDetailList
implements YSubDetailListImplementation {
    private YSubDetailListManager subDetailListManager;
    private String masterFilter;

    public YLinkedSubDetailList(YSession session, int maxColumns, YDetailList detailList) throws YException {
        super(session, maxColumns, detailList.masterRowObject);
        this.subDetailListManager = new YSubDetailListManager(detailList, this);
    }

    public YLinkedSubDetailList(YSession session, int maxColumns, YDetailList detailList, int masterId) throws YException {
        super(session, maxColumns, masterId);
        this.subDetailListManager = new YSubDetailListManager(detailList, this);
    }

    @Override
    public YColumnDefinition addRowObjectFkField(String fieldName) throws YException {
        return this.addRowObjectFkField(fieldName, false);
    }

    protected YColumnDefinition addMasterFkField(String fieldName) throws YException {
        this.masterRowFkDefinition = this.addLinkDBField(fieldName, YColumnDefinition.FieldType.INT);
        return this.masterRowFkDefinition;
    }

    @Override
    public void setOrder(String[] order, boolean desc) throws YProgramException {
        this.subDetailListManager.checkOrder(order);
        super.setOrder(order, desc);
    }

    @Override
    protected void checkFinalized() throws YProgramException {
        super.checkFinalized();
        this.subDetailListManager.checkOrder(this.masterRowFkDefinition);
    }

    @Override
    public void setMasterFilter(String tableName, String pkName, String filter) {
        this.masterFilter = this.subDetailListManager.createMasterFilter(tableName, this.tableAlias, pkName, filter, this.andWhere);
    }

    @Override
    public YLinkedSubDetailList fetch() throws YException {
        String andWhere = this.andWhere;
        try {
            if (this.masterFilter != null) {
                this.setAndWhere(this.masterFilter);
            }
            ++this.changeLevel;
            super.fetch();
            this.subDetailListManager.linkRows();
            YLinkedSubDetailList yLinkedSubDetailList = this;
            return yLinkedSubDetailList;
        }
        finally {
            this.setAndWhere(andWhere);
            --this.changeLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public YLinkedSubDetailList fetch(int rowObjectId) throws YException {
        String andWhere = this.andWhere;
        try {
            if (this.masterFilter != null) {
                this.setAndWhere(this.masterFilter);
            }
            super.fetch(rowObjectId);
            this.subDetailListManager.linkRows();
            YLinkedSubDetailList yLinkedSubDetailList = this;
            return yLinkedSubDetailList;
        }
        finally {
            this.setAndWhere(andWhere);
        }
    }

    @Override
    public void setSubWindow(int detailRowId) throws YException {
        this.subDetailListManager.setSubWindow(detailRowId);
    }

    @Override
    public int unsetSubWindow() throws YException {
        return this.subDetailListManager.unsetSubWindow();
    }

    @Override
    public YRowValues append(YRowObject rowObject) throws YException {
        return this.subDetailListManager.append(rowObject);
    }

    @Override
    public int qualify(int rowObjId) throws YException {
        if (!this.subDetailListManager.hasSubWindow()) {
            throw new YProgramException(this, "Kein Fenster (setSubWindow()) eingestellt.");
        }
        ++this.changeLevel;
        YRowValues rowValues = this.qualifyDetails(rowObjId);
        rowValues.getFieldValue(this.detailFkDefinition).gotValue(Integer.toString(rowObjId));
        this.addRowValues(rowValues);
        --this.changeLevel;
        return this.subDetailListManager.appendRowValues(rowValues);
    }

    @Override
    int getMasterFkValueAsInt(YRowValues rowValues) throws YException {
        return rowValues.getFieldValue(this.masterRowFkDefinition).getValueAsInt();
    }

    @Override
    public int getRowCount() throws YException {
        return this.subDetailListManager.getRowCount();
    }

    @Override
    public YRowValues getRowValues(int iRow) throws YException {
        return this.subDetailListManager.getRowValues(iRow);
    }

    @Override
    protected YRowValues getRowValues4Set(int iRow) throws YException {
        return this.subDetailListManager.getRowValues4Set(iRow);
    }

    @Override
    public boolean setPosted() throws YException {
        boolean hasChanged = super.setPosted();
        this.subDetailListManager.unsetSubWindow();
        return hasChanged;
    }

    int getDetailRowId() {
        return this.subDetailListManager.getDetailRowId();
    }

    public boolean hasSubWindow() {
        return this.subDetailListManager.hasSubWindow();
    }

    int getIRow0() {
        return this.subDetailListManager.getIRow0();
    }

    int getIRowN() {
        return this.subDetailListManager.getIRowN();
    }

    @Override
    public void unsetPosted() throws YException {
        super.unsetPosted();
    }

    @Override
    public YRowValues createRowValues() throws YException {
        return super.createRowValues();
    }

    @Override
    public YRowValues addRowValues(int iAbsRow, YRowValues rowValues) throws YException {
        super.addRowValues(iAbsRow, rowValues);
        return rowValues;
    }

    @Override
    public void checkNotNull() throws YNullValueException, YException {
        super.checkNotNull();
    }
}

