/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import java.util.TreeMap;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDatabase;
import projektY.database.YEvaluationList;
import projektY.database.YFieldValue;
import projektY.database.YRowObjectList;
import projektY.database.YRowValues;
import projektY.database.YSession;

public class YMatrixRowList
extends YRowObjectList {
    private YRowObjectList columnDefinitionList;
    private YEvaluationList matrixTableList;
    private String matrixTableName;
    private YColumnDefinition rowFkDefinition;
    private YColumnDefinition columnFkDefinition;
    private YColumnDefinition valueDefinition;
    private YColumnDefinition labelDefinition;
    private YColumnDefinition codeDefinition;
    private TreeMap<String, Integer> columnIndicees;

    public YMatrixRowList(YSession session, int maxColumns, YRowObjectList columnDefinitionList) throws YException {
        super(session, maxColumns + columnDefinitionList.fetch().getRowCount());
        this.columnDefinitionList = columnDefinitionList;
        this.matrixTableList = new YEvaluationList(session, 3);
        this.columnIndicees = new TreeMap();
    }

    public YColumnDefinition addRowFkField(String fieldName) throws YException {
        this.rowFkDefinition = this.matrixTableList.addDBField(fieldName, YColumnDefinition.FieldType.INT);
        return this.rowFkDefinition;
    }

    public YColumnDefinition addColumnFkField(String fieldName) throws YException {
        this.columnFkDefinition = this.matrixTableList.addDBField(fieldName, YColumnDefinition.FieldType.INT);
        return this.columnFkDefinition;
    }

    public YColumnDefinition addValueField(String fieldName, YColumnDefinition.FieldType fieldType) throws YException {
        this.valueDefinition = this.matrixTableList.addDBField(fieldName, fieldType);
        return this.valueDefinition;
    }

    public void setMatrixTableName(String matrixTableName) throws YException {
        this.matrixTableName = matrixTableName;
    }

    public void setLabelField(String fieldName) throws YException {
        this.labelDefinition = this.columnDefinitionList.getColumnDefinition(fieldName);
    }

    public void setCodeField(String fieldName) throws YException {
        this.codeDefinition = this.columnDefinitionList.getColumnDefinition(fieldName);
    }

    @Override
    protected void checkFinalized() throws YProgramException {
        try {
            if (this.rowFkDefinition == null || this.columnFkDefinition == null || this.valueDefinition == null) {
                throw new YException("Es wurden nicht alle drei Felder der Matrixtabelle definiert.");
            }
            if (this.labelDefinition == null) {
                throw new YException("Das Label-Feld der Spaltendefinition wurde nicht definiert.");
            }
            int nCols = this.columnDefinitionList.getRowCount();
            for (int iCol = 0; iCol < nCols; ++iCol) {
                YColumnDefinition columnDefinition = this.rowDefinition.addAliasDefinition("*" + iCol + "*", this.valueDefinition);
                columnDefinition.setLabel(this.columnDefinitionList.getAsString(iCol, this.labelDefinition.getName()));
                if (this.codeDefinition == null) continue;
                this.columnIndicees.put(this.columnDefinitionList.getAsString(iCol, this.codeDefinition.getName()), new Integer(iCol));
            }
            if (this.matrixTableName == null) {
                throw new YException("Der Name der Matrixtabelle wurde nicht definiert.");
            }
            this.matrixTableList.setSqlSelect("SELECT " + this.rowFkDefinition.getName() + ", " + this.columnFkDefinition.getName() + ", " + this.valueDefinition.getName() + " FROM " + this.matrixTableName);
            this.matrixTableList.addFilter("rowFkValue", this.rowFkDefinition.getName() + "=:value:", YColumnDefinition.FieldType.INT);
            this.matrixTableList.finalize();
        }
        catch (YException e) {
            throw new YProgramException(this, e.toString());
        }
        super.checkFinalized();
    }

    @Override
    public int getDispColCount() throws YException {
        try {
            return super.getDispColCount() + this.columnDefinitionList.getRowCount();
        }
        catch (YException e) {
            return super.getDispColCount();
        }
    }

    @Override
    public YColumnDefinition getDispColumnDefinition(int iCol) throws YException {
        int nCols = super.getDispColCount();
        if (iCol < nCols) {
            return super.getDispColumnDefinition(iCol);
        }
        return this.rowDefinition.getColumnDefinition("*" + (iCol - nCols) + "*");
    }

    @Override
    public String getDispString(int iRow, int iCol) throws YException {
        int nCols = super.getDispColCount();
        if (iCol < nCols) {
            return super.getDispString(iRow, iCol);
        }
        return this.getRowValues(iRow).getAsString("*" + (iCol - nCols) + "*");
    }

    @Override
    public YFieldValue getDispValue(int iRow, int iCol) throws YException {
        int nCols = super.getDispColCount();
        if (iCol < nCols) {
            return super.getDispValue(iRow, iCol);
        }
        return this.getRowValues(iRow).getFieldValue("*" + (iCol - nCols) + "*");
    }

    @Override
    public void setDispString(int iRow, int iCol, String value) throws YException {
        int nCols = super.getDispColCount();
        if (iCol < nCols) {
            super.setDispString(iRow, iCol, value);
        } else {
            this.getDispValue(iRow, iCol).modifyValue(value);
            this.fireChanged(new YDBOChangeEvent(iRow, this.getRowValues(iRow), iCol));
        }
    }

    @Override
    public void clearDispValues(int iRow) throws YException {
        int nCols = this.columnDefinitionList.getRowCount();
        for (int iCol = 0; iCol < nCols; ++iCol) {
            this.getRowValues(iRow).getFieldValue("*" + iCol + "*").modifyToNull();
        }
        super.clearDispValues(iRow);
    }

    @Override
    public YFieldValue getFieldValue(int iRow, String fieldName) throws YException {
        if (this.rowDefinition.isColumnDefined(fieldName)) {
            return super.getFieldValue(iRow, fieldName);
        }
        Integer iCol = this.columnIndicees.get(fieldName);
        if (iCol == null) {
            throw new YProgramException(this, "Kodierung '" + fieldName + "' nicht gefunden");
        }
        return this.getRowValues(iRow).getFieldValue("*" + iCol + "*");
    }

    @Override
    public boolean hasChanged() {
        try {
            int nRows = this.getRowCount();
            int nCols = this.rowDefinition.getNColumns();
            for (int iRow = 0; iRow < nRows; ++iRow) {
                YRowValues rowValues = this.getRowValues(iRow);
                for (int iCol = 0; iCol < nCols; ++iCol) {
                    if (!rowValues.getFieldValue(iCol).hasChanged()) continue;
                    rowValues.coldefChanged = rowValues.getFieldValue(iCol).getColumnDefinition();
                    return true;
                }
                rowValues.coldefChanged = null;
            }
            return false;
        }
        catch (YException e) {
            return true;
        }
    }

    @Override
    public YMatrixRowList fetch() throws YException {
        super.fetch();
        int nRows = this.getRowCount();
        int nCols = this.columnDefinitionList.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            this.matrixTableList.setFilterValue("rowFkValue", this.getAsString(iRow, this.getRowValues(iRow).getPkFieldValue().getColumnDefinition().getName()));
            this.matrixTableList.fetch();
            YRowValues rowValues = this.getRowValues(iRow);
            for (int iCol = 0; iCol < nCols; ++iCol) {
                int iColRow = this.matrixTableList.find(this.columnDefinitionList.getRowValues(iCol).getPkFieldValue().getValue(), this.columnFkDefinition.getName());
                if (iColRow >= 0) {
                    rowValues.getFieldValue("*" + iCol + "*").gotValue(this.matrixTableList.getAsString(iColRow, this.valueDefinition.getName()));
                    continue;
                }
                rowValues.getFieldValue("*" + iCol + "*").gotValue("");
            }
            this.fireChanged(new YDBOChangeEvent());
        }
        return this;
    }

    @Override
    protected boolean setPosted() throws YException {
        boolean hasChanged = super.setPosted();
        int nRows = this.getRowCount();
        int nCols = this.columnDefinitionList.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            for (int iCol = 0; iCol < nCols; ++iCol) {
                this.getRowValues(iRow).getFieldValue("*" + iCol + "*").setPosted();
            }
        }
        return hasChanged;
    }

    @Override
    public void post() throws YException {
        YDatabase database = this.session.getDatabase();
        boolean wasInTransaction = database.isInTransaction();
        String sql = null;
        String rowFkName = this.rowFkDefinition.getName();
        String columnFkName = this.columnFkDefinition.getName();
        String valueFieldName = this.valueDefinition.getName();
        if (!wasInTransaction) {
            this.setDefaults();
            this.checkNotNull();
        }
        try {
            if (!database.isInTransaction()) {
                database.startTransaction();
            }
            super.post();
            int nRows = this.getRowCount();
            int nCols = this.columnDefinitionList.getRowCount();
            for (int iRow = 0; iRow < nRows; ++iRow) {
                YRowValues rowValues = this.getRowValues(iRow);
                String rowFkValue = rowValues.getPkFieldValue().toString();
                for (int iCol = 0; iCol < nCols; ++iCol) {
                    YFieldValue fieldValue = rowValues.getFieldValue("*" + iCol + "*");
                    if (!fieldValue.hasChanged()) continue;
                    String columnFkValue = this.columnDefinitionList.getRowValues(iCol).getPkFieldValue().getValue();
                    if (fieldValue.wasNull()) {
                        sql = "INSERT INTO " + this.matrixTableName + " (" + rowFkName + ", " + columnFkName + ", " + valueFieldName + ") VALUES (" + rowFkValue + ", " + columnFkValue + ", " + this.sqlValue(fieldValue) + ")";
                    } else if (fieldValue.isNull()) {
                        if (!rowValues.hasDeleteMark()) {
                            sql = "DELETE FROM " + this.matrixTableName + " WHERE " + rowFkName + "=" + rowFkValue + " AND " + columnFkName + "=" + columnFkValue;
                        }
                    } else {
                        sql = "UPDATE " + this.matrixTableName + " SET " + valueFieldName + "=" + this.sqlValue(fieldValue) + " WHERE " + rowFkName + "=" + rowFkValue + " AND " + columnFkName + "=" + columnFkValue;
                    }
                    if (sql == null) continue;
                    this.sqlDml.execute(sql);
                }
            }
            if (!wasInTransaction && database.isInTransaction()) {
                database.commit();
                if (this.setPosted()) {
                    this.fireChanged(new YDBOChangeEvent());
                }
            }
        }
        catch (YException e) {
            if (!wasInTransaction && database.isInTransaction()) {
                database.rollback();
                this.unsetPosted();
            }
            throw e;
        }
    }
}

