/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Locale;
import projektY.base.YException;
import projektY.database.YDatabase;
import projektY.database.YFieldValue;

public abstract class YPGDatabase
extends YDatabase {
    protected TimeoutManager timeoutManager = null;
    private String passwdUser = null;

    public YPGDatabase(String driver, String URL2, Locale locale) throws YException {
        super(driver, URL2, locale);
    }

    @Override
    public void begin() throws YException {
        super.begin();
        try {
            this.sqlDml.execute("BEGIN");
        }
        catch (YException e) {
            this.inTransaction = false;
            throw e;
        }
    }

    @Override
    public String getTrue() {
        return "TRUE";
    }

    @Override
    public String getFalse() {
        return "FALSE";
    }

    public static final String cryptMd5(char[] passwd, String user) throws YException {
        if (passwd.length == 0) {
            return "";
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] md5Password = messageDigest.digest((new String(passwd) + user).getBytes());
            StringBuffer md5String = new StringBuffer(3 + md5Password.length * 2);
            md5String.append("md5");
            for (int i = 0; i < md5Password.length; ++i) {
                md5String.append(String.format("%02x", md5Password[i]));
            }
            return md5String.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new YException(ex.toString());
        }
    }

    @Override
    protected void createUser(String user, char[] passwd) throws YException {
        if (this.initializedTransaction) {
            this.begin();
        }
        this.sqlDml.execute("CREATE USER \"" + user + "\" WITH ENCRYPTED PASSWORD '" + YPGDatabase.cryptMd5(passwd, user) + "'");
    }

    @Override
    protected void alterPasswd(String user, char[] passwd) throws YException {
        if (this.initializedTransaction) {
            this.begin();
        }
        this.sqlDml.execute("ALTER USER \"" + user + "\" ENCRYPTED PASSWORD '" + YPGDatabase.cryptMd5(passwd, user) + "'");
    }

    @Override
    protected void grantAdmin(String user) throws YException {
        if (this.initializedTransaction) {
            this.begin();
        }
        this.sqlDml.execute("ALTER USER \"" + user + "\" CREATEROLE");
    }

    @Override
    protected void revokeAdmin(String user) throws YException {
        if (this.initializedTransaction) {
            this.begin();
        }
        this.sqlDml.execute("ALTER USER \"" + user + "\" NOCREATEUSER");
    }

    @Override
    protected void dropUser(String user) throws YException {
        if (this.initializedTransaction) {
            this.begin();
        }
        this.sqlDml.execute("DROP USER IF EXISTS " + user);
    }

    @Override
    protected void grantRole(String role, String user) throws YException {
        if (this.initializedTransaction) {
            this.begin();
        }
        this.sqlDml.execute("GRANT " + role + " TO \"" + user + "\"");
    }

    @Override
    protected void revokeRole(String role, String user) throws YException {
        if (this.initializedTransaction) {
            this.begin();
        }
        this.sqlDml.execute("REVOKE " + role + " FROM \"" + user + "\"");
    }

    @Override
    public boolean isFkViolation(SQLException ex) {
        try {
            return Integer.parseInt(ex.getSQLState()) == 23503;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean isUniqueViolation(SQLException ex) {
        try {
            return Integer.parseInt(ex.getSQLState()) == 23505;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void setPasswdUser(String passwdUser) throws YException {
        this.passwdUser = passwdUser;
    }

    @Override
    public void modifyPasswdField(YFieldValue pwdFv, char[] passwd) throws YException {
        pwdFv.modifyValue(YPGDatabase.cryptMd5(passwd, this.passwdUser == null ? this.getUser() : this.passwdUser));
    }

    public void setTimeout(int sekunden) {
        if (this.timeoutManager == null) {
            this.timeoutManager = new TimeoutManager(this, sekunden);
            this.timeoutManager.start();
        } else {
            this.timeoutManager.setTimeout(sekunden);
            if (sekunden <= 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.timeoutManager = null;
            }
        }
    }

    protected class TimeoutManager
    extends Thread {
        private int sekunden;
        private final YDatabase database;

        public TimeoutManager(YDatabase database, int sekunden) {
            this.database = database;
            this.sekunden = sekunden;
        }

        public void setTimeout(int sekunden) {
            this.sekunden = sekunden;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                if (this.sekunden <= 0) {
                    if (YPGDatabase.this.sqlLog) {
                        System.out.println("Timeout beendet");
                    }
                    return;
                }
                try {
                    if (YPGDatabase.this.sqlLog) {
                        System.out.println("Timeout gestartet");
                    }
                    Thread.sleep(this.sekunden * 1000);
                    YDatabase yDatabase = this.database;
                    synchronized (yDatabase) {
                        if (YPGDatabase.this.sqlLog) {
                            System.out.println("Timeout erreicht");
                        }
                        if (this.database.isInTransaction()) {
                            continue;
                        }
                        if (this.database.isConnected()) {
                            this.database.disconnect();
                            if (YPGDatabase.this.sqlLog) {
                                System.out.println("disconnect() ausgef\u00fchrt");
                            }
                        }
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    if (!YPGDatabase.this.sqlLog) continue;
                    System.out.print("Timeout zur\u00fcckgesetzt ... ");
                    continue;
                }
                break;
            }
        }
    }
}

