/*
 * Decompiled with CFR 0.152.
 */
package projektY.database.jLibY;

import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YRowDefinition;
import projektY.database.jLibY.YAliasColumnDefinition;
import projektY.database.jLibY.YAsColumnDefinition;
import projektY.database.jLibY.YFkEmbeddedColumnDefinition;
import projektY.database.jLibY.YStandardRowDefinition;

public abstract class YPostableRowDefinition
extends YRowDefinition {
    private String tableName;
    YPostableRowDefinition parentDefinition;
    private YColumnDefinition idColumnDefinition;
    YColumnDefinition objDepColdef;
    private boolean implDep;
    int aliasId;

    YPostableRowDefinition(String tableName, YColumnDefinition idColumnDefinition, YColumnDefinition objDepColdef) throws YProgramException {
        this.tableName = tableName;
        if (!idColumnDefinition.isPrimaryKey()) {
            throw new YProgramException(this, "Id-Spalte '" + idColumnDefinition + "' mu\u00df als Prim\u00e4rschl\u00fcssel definiert sein.");
        }
        idColumnDefinition.setFieldValueIndex(this.getNColumns());
        this.addColumnDefinition(idColumnDefinition);
        this.idColumnDefinition = idColumnDefinition;
        this.parentDefinition = null;
        this.objDepColdef = objDepColdef;
        if (objDepColdef != null) {
            objDepColdef.setFieldValueIndex(this.getNColumns());
            this.addColumnDefinition(objDepColdef);
        }
        this.implDep = false;
    }

    YPostableRowDefinition(String tableName, String idColumnName, String objDepColumnName) throws YProgramException {
        this(tableName, new YColumnDefinition(idColumnName, YColumnDefinition.FieldType.INT, true, false), new YColumnDefinition(objDepColumnName, YColumnDefinition.FieldType.INT, false, false));
    }

    YPostableRowDefinition(String tableName, YColumnDefinition idColumnDefinition) throws YProgramException {
        this(tableName, idColumnDefinition, null);
    }

    protected YPostableRowDefinition(String tableName, String idName) throws YProgramException {
        this(tableName, new YColumnDefinition(idName, YColumnDefinition.FieldType.INT, true, false));
    }

    public YAliasColumnDefinition addAliasDefinition(String aliasName, YPostableRowDefinition rootRowDefinition, String rootColumnName) throws YProgramException {
        for (int iCol = 0; iCol < this.getNColumns(); ++iCol) {
            YAliasColumnDefinition asAlias;
            YColumnDefinition columnDefinition = this.getColumnDefinition(iCol);
            if (!(columnDefinition instanceof YAliasColumnDefinition) || (asAlias = (YAliasColumnDefinition)columnDefinition).getRootRowDefinition() != rootRowDefinition || !rootColumnName.equals(asAlias.getRootDefinition().getName())) continue;
            throw new YProgramException(this, rootRowDefinition.getTableName() + "." + rootColumnName + " wurde einmal als '" + asAlias.getName() + "' und einmal als '" + aliasName + "' hinzugef\u00fcgt.\nMit dieser Mehrdeutigkeit ist die Zeile nicht speicherbar.");
        }
        YAliasColumnDefinition aliasColumnDefinition = new YAliasColumnDefinition(this.getNColumns(), aliasName, rootRowDefinition, rootColumnName);
        this.addColumnDefinition(aliasColumnDefinition);
        return aliasColumnDefinition;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getAliasId() {
        return this.aliasId;
    }

    public YFkEmbeddedColumnDefinition addFkEmbeddedDefinition(YFkEmbeddedColumnDefinition fkEmbeddedColumnDefinition) throws YProgramException {
        fkEmbeddedColumnDefinition.setFieldValueIndex(this.getNColumns());
        this.addColumnDefinition(fkEmbeddedColumnDefinition);
        fkEmbeddedColumnDefinition.rowDefinition = this;
        return fkEmbeddedColumnDefinition;
    }

    public YFkEmbeddedColumnDefinition addDependencyDefinition(YFkEmbeddedColumnDefinition objDepColdef) throws YProgramException {
        if (this.objDepColdef != null) {
            throw new YProgramException(this, "Mehrfache explizite Abh\u00e4ngigkeit ist nicht erlaubt.");
        }
        if (objDepColdef.definesImplicitDependent()) {
            throw new YProgramException(this, "Wechselseitige Abh\u00e4ngigkeit ist nicht m\u00f6glich.");
        }
        this.objDepColdef = objDepColdef;
        objDepColdef.setFieldValueIndex(this.getNColumns());
        this.addColumnDefinition(objDepColdef);
        objDepColdef.rowDefinition = this;
        return objDepColdef;
    }

    public YColumnDefinition addObjectDependencyDefinition(String fkName) throws YProgramException {
        if (this.implDep || this.objDepColdef != null) {
            throw new YProgramException(this, "Mehrfache Abh\u00e4ngigkeit ist nicht erlaubt.");
        }
        this.objDepColdef = new YColumnDefinition(fkName, YColumnDefinition.FieldType.INT, false, false);
        this.objDepColdef.setFieldValueIndex(this.getNColumns());
        this.objDepColdef.setNotNull();
        this.addColumnDefinition(this.objDepColdef);
        return this.objDepColdef;
    }

    void setImplicitDependent() throws YProgramException {
        if (this.implDep) {
            throw new YProgramException(this, "Mehrfache implizite Abh\u00e4ngigkeit ist nicht erlaubt.");
        }
        this.implDep = true;
    }

    protected int organizeAliasIds(int startWithAlias) throws YProgramException {
        int nCols = this.getNColumns();
        for (int iCol = 0; iCol < nCols; ++iCol) {
            YFkEmbeddedColumnDefinition fkEmbeddedColumnDefinition;
            YColumnDefinition columnDefinition = this.getColumnDefinition(iCol);
            if (!(columnDefinition instanceof YFkEmbeddedColumnDefinition) || !(fkEmbeddedColumnDefinition = (YFkEmbeddedColumnDefinition)columnDefinition).isEmbeddingUsed()) continue;
            fkEmbeddedColumnDefinition.getEmbeddedRowDefinition().aliasId = startWithAlias++;
            YStandardRowDefinition embeddedRowDefinition = fkEmbeddedColumnDefinition.getEmbeddedRowDefinition();
            startWithAlias = ((YPostableRowDefinition)embeddedRowDefinition).organizeAliasIds(startWithAlias);
        }
        return startWithAlias;
    }

    int organizeAliasIds() throws YProgramException {
        return this.organizeAliasIds(1);
    }

    @Override
    public YColumnDefinition getPkColumnDefinition() {
        return this.idColumnDefinition;
    }

    public YColumnDefinition getIdColumnDefinition() {
        return this.idColumnDefinition;
    }

    public YFkEmbeddedColumnDefinition getFkEmbeddedDefinition(String fkFieldName) throws YProgramException {
        YColumnDefinition columnDefinition = this.getColumnDefinition(fkFieldName);
        if (!(columnDefinition instanceof YFkEmbeddedColumnDefinition)) {
            throw new YProgramException(this, fkFieldName + " ist keine Enbettung mit Fremdschl\u00fcssel");
        }
        return (YFkEmbeddedColumnDefinition)columnDefinition;
    }

    public YPostableRowDefinition getFkEmbeddedRowDefinition(String fkFieldName) throws YProgramException {
        YColumnDefinition columnDefinition = this.getColumnDefinition(fkFieldName);
        if (!(columnDefinition instanceof YFkEmbeddedColumnDefinition)) {
            throw new YProgramException(this, fkFieldName + " ist keine Enbettung mit Fremdschl\u00fcssel");
        }
        YFkEmbeddedColumnDefinition fkEmbeddedColumnDefinition = (YFkEmbeddedColumnDefinition)columnDefinition;
        return fkEmbeddedColumnDefinition.getEmbeddedRowDefinition();
    }

    public String getLabel(YColumnDefinition columnDefinition) {
        int nCols = this.getNColumns();
        for (int iCol = 0; iCol < nCols; ++iCol) {
            YColumnDefinition labelColDef;
            YColumnDefinition colDef = labelColDef = this.getColumnDefinition(iCol);
            while (colDef.isAlias()) {
                colDef = colDef.getAliasFor();
            }
            if (colDef != columnDefinition) continue;
            return labelColDef.getLabel();
        }
        return columnDefinition.getLabel();
    }

    public boolean isExplicitDependent() {
        return this.objDepColdef != null;
    }

    public boolean isImplicitDependent() {
        return this.implDep;
    }

    public boolean isDependent() {
        return this.implDep || this.objDepColdef != null;
    }

    public YColumnDefinition getObjDepColumnDefinition() {
        return this.objDepColdef;
    }

    protected void appendAsColumns(StringBuffer sql) throws YProgramException {
    }

    void appendJoins(StringBuffer sql, YPostableRowDefinition rowDefinition) throws YProgramException {
        int nCols = rowDefinition.getNColumns();
        String rowAlias = rowDefinition.aliasId == 0 ? "t" : "t" + rowDefinition.aliasId;
        for (int iCol = 0; iCol < nCols; ++iCol) {
            YFkEmbeddedColumnDefinition fkEmbeddedColumnDefinition;
            YColumnDefinition columnDefinition = rowDefinition.getColumnDefinition(iCol);
            if (!(columnDefinition instanceof YFkEmbeddedColumnDefinition) || !(fkEmbeddedColumnDefinition = (YFkEmbeddedColumnDefinition)columnDefinition).isEmbeddingUsed()) continue;
            YStandardRowDefinition embeddedRowDefinition = fkEmbeddedColumnDefinition.getEmbeddedRowDefinition();
            String joinTableName = embeddedRowDefinition.getTableName();
            if (!fkEmbeddedColumnDefinition.isPrimaryKey()) {
                sql.append(" LEFT OUTER");
            }
            sql.append(" JOIN " + joinTableName + " t" + embeddedRowDefinition.aliasId + " ON (t" + embeddedRowDefinition.aliasId + "." + embeddedRowDefinition.getIdColumnDefinition().getName() + "=" + rowAlias + "." + fkEmbeddedColumnDefinition.getName() + ")");
            this.appendJoins(sql, embeddedRowDefinition);
        }
    }

    protected void appendJoins(StringBuffer sql) throws YProgramException {
        this.appendJoins(sql, this);
    }

    protected void appendWhere(StringBuffer sql) throws YProgramException {
        sql.append("t." + this.getIdColumnDefinition().getName() + "=:id:");
    }

    public String createParamSelect() throws YProgramException {
        StringBuffer sql = new StringBuffer(200);
        this.organizeAliasIds();
        for (int iCol = 0; iCol < this.getNColumns(); ++iCol) {
            YColumnDefinition columnDefinition = this.getColumnDefinition(iCol);
            if (columnDefinition.isAlias()) {
                if (!(columnDefinition instanceof YAliasColumnDefinition)) {
                    throw new YProgramException(this, "Falsche Aliasdefinition verwendet.");
                }
                YAliasColumnDefinition aliasDefinition = (YAliasColumnDefinition)columnDefinition;
                YColumnDefinition rootDefinition = aliasDefinition.getRootDefinition();
                if (sql.length() > 0) {
                    sql.append(", ");
                }
                sql.append("t" + aliasDefinition.getRootRowAliasId() + ".");
                sql.append(rootDefinition.getName());
                if (rootDefinition.getName().equals(columnDefinition.getName())) continue;
                sql.append(" AS " + columnDefinition.getName());
                continue;
            }
            if (columnDefinition instanceof YAsColumnDefinition) continue;
            if (sql.length() > 0) {
                sql.append(", ");
            }
            sql.append("t." + columnDefinition.getName());
        }
        this.appendAsColumns(sql);
        sql.append(" FROM " + this.getTableName() + " t");
        this.appendJoins(sql);
        sql.append(" WHERE ");
        this.appendWhere(sql);
        return "SELECT " + sql.toString();
    }
}

