/*
 * Decompiled with CFR 0.152.
 */
package projektY.swing;

import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import projektY.base.YException;
import projektY.base.YLookUpDomain;
import projektY.base.YLookUpValue;
import projektY.database.YDatabaseList;
import projektY.database.YRowValues;

public class YComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private int notNullOffset;
    private YDatabaseList databaseList;
    private YRowValues selectedRowValues;
    private YLookUpDomain lookUpDomain;
    private YLookUpValue selectedLookUpObject;

    public YComboBoxModel(YDatabaseList databaseList, boolean notNull) {
        this.databaseList = databaseList;
        this.notNullOffset = notNull ? 0 : 1;
    }

    public YComboBoxModel(YDatabaseList databaseList) {
        this(databaseList, true);
    }

    public YComboBoxModel(YLookUpDomain lookUpDomain, boolean notNull) {
        this.lookUpDomain = lookUpDomain;
        this.notNullOffset = notNull ? 0 : 1;
    }

    public YComboBoxModel(YLookUpDomain lookUpDomain) {
        this(lookUpDomain, true);
    }

    @Override
    public int getSize() {
        try {
            if (this.databaseList != null) {
                return this.databaseList.getRowCount() + this.notNullOffset;
            }
            return this.lookUpDomain.getValueCount() + this.notNullOffset;
        }
        catch (YException e) {
            return 0;
        }
    }

    @Override
    public Object getElementAt(int index) {
        try {
            if (index < this.notNullOffset) {
                return null;
            }
            index -= this.notNullOffset;
            if (this.databaseList != null) {
                if (index >= this.databaseList.getRowCount()) {
                    return null;
                }
                return this.databaseList.getRowValues(index);
            }
            if (index >= this.lookUpDomain.getValueCount()) {
                return null;
            }
            return this.lookUpDomain.getLookUpObject(index);
        }
        catch (YException e) {
            return null;
        }
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (this.databaseList != null) {
            if (anItem == null) {
                if (this.selectedRowValues != null) {
                    this.selectedRowValues = null;
                    this.fireContentsChanged(this, -1, -1);
                }
            } else {
                if (anItem instanceof YRowValues) {
                    this.selectedRowValues = (YRowValues)anItem;
                } else {
                    String strItem = anItem.toString();
                    try {
                        int iRow;
                        if (this.selectedRowValues != null && this.selectedRowValues.toString().equals(strItem)) {
                            return;
                        }
                        for (iRow = 0; iRow < this.databaseList.getRowCount(); ++iRow) {
                            YRowValues rowValues = this.databaseList.getRowValues(iRow);
                            if (!rowValues.toString().equals(strItem)) continue;
                            this.selectedRowValues = rowValues;
                            break;
                        }
                        if (iRow >= this.databaseList.getRowCount()) {
                            return;
                        }
                    }
                    catch (YException iRow) {
                        // empty catch block
                    }
                }
                this.fireContentsChanged(this, -1, -1);
            }
        } else if (anItem == null) {
            if (this.selectedLookUpObject != null) {
                this.selectedLookUpObject = null;
                this.fireContentsChanged(this, -1, -1);
            }
        } else {
            if (anItem instanceof YLookUpValue) {
                this.selectedLookUpObject = (YLookUpValue)anItem;
            } else {
                String strItem = anItem.toString();
                try {
                    int iRow;
                    if (this.selectedLookUpObject != null && this.selectedLookUpObject.toString().equals(strItem)) {
                        return;
                    }
                    for (iRow = 0; iRow < this.lookUpDomain.getValueCount(); ++iRow) {
                        YLookUpValue lookUpValue = this.lookUpDomain.getLookUpObject(iRow);
                        if (!lookUpValue.toString().equals(strItem)) continue;
                        this.selectedLookUpObject = lookUpValue;
                        break;
                    }
                    if (iRow >= this.lookUpDomain.getValueCount()) {
                        return;
                    }
                }
                catch (YException yException) {
                    // empty catch block
                }
            }
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getSelectedItem() {
        if (this.databaseList != null) {
            if (this.selectedRowValues == null) {
                return null;
            }
            return this.selectedRowValues;
        }
        if (this.selectedLookUpObject == null) {
            return null;
        }
        return this.selectedLookUpObject;
    }

    public YRowValues getSelectedRowValues() {
        if (this.selectedRowValues == null) {
            return null;
        }
        return this.selectedRowValues;
    }

    public YLookUpValue getSelectedLookUpValue() {
        if (this.selectedLookUpObject == null) {
            return null;
        }
        return this.selectedLookUpObject;
    }
}

