/*
 * Decompiled with CFR 0.152.
 */
package projektY.utils;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.util.Vector;
import projektY.base.YException;

public class YConfigFile {
    File configFile;
    private Vector<ConfigEntry> configEntries = new Vector(20);
    private boolean hasChanged;

    public YConfigFile(String fileName) throws YException {
        this.configFile = new File(System.getProperty("user.home") + File.separator + fileName);
        if (this.configFile.exists()) {
            try {
                String line;
                if (!this.configFile.isFile()) {
                    throw new YException(fileName + " ist keine Datei.");
                }
                if (!this.configFile.canRead()) {
                    throw new YException(fileName + " ist nicht lesbar.");
                }
                LineNumberReader configReader = new LineNumberReader(new FileReader(this.configFile));
                while ((line = configReader.readLine()) != null) {
                    this.addEntry(line);
                }
            }
            catch (IOException ex) {
                throw new YException("I/O-Fehler beim Lesen der Konfigurationsdatei: " + ex.toString());
            }
        }
        this.hasChanged = false;
    }

    public final String getFileName() {
        return this.configFile.getAbsolutePath();
    }

    private void addEntry(String line) {
        int iEq = line.indexOf(61);
        if (iEq < 1) {
            this.hasChanged = true;
            return;
        }
        String name = line.substring(0, iEq).trim();
        String value = line.substring(iEq + 1).trim();
        if (name.length() == 0) {
            this.hasChanged = true;
            return;
        }
        int nEntries = this.configEntries.size();
        for (int iEntry = 0; iEntry < nEntries; ++iEntry) {
            ConfigEntry configEntry = this.configEntries.get(iEntry);
            if (!configEntry.getName().equals(name)) continue;
            this.hasChanged = true;
            return;
        }
        this.configEntries.add(new ConfigEntry(name, value));
    }

    public void setEntry(String name, String value) {
        int nEntries = this.configEntries.size();
        for (int iEntry = 0; iEntry < nEntries; ++iEntry) {
            ConfigEntry configEntry = this.configEntries.get(iEntry);
            if (!configEntry.getName().equals(name)) continue;
            if (!configEntry.getValue().equals(value)) {
                configEntry.setValue(value);
                this.hasChanged = true;
            }
            return;
        }
        this.configEntries.add(new ConfigEntry(name, value));
        this.hasChanged = true;
    }

    public String findValue(String name) {
        int nEntries = this.configEntries.size();
        for (int iEntry = 0; iEntry < nEntries; ++iEntry) {
            ConfigEntry configEntry = this.configEntries.get(iEntry);
            if (!configEntry.getName().equals(name)) continue;
            return configEntry.getValue();
        }
        return "";
    }

    public boolean existsEntry(String name) {
        int nEntries = this.configEntries.size();
        for (int iEntry = 0; iEntry < nEntries; ++iEntry) {
            if (!this.configEntries.get(iEntry).getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean entryExists(String name) {
        int nEntries = this.configEntries.size();
        for (int iEntry = 0; iEntry < nEntries; ++iEntry) {
            if (!this.configEntries.get(iEntry).getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getEntry(String name, String defaultValue) {
        if (this.entryExists(name)) {
            return this.findValue(name);
        }
        return defaultValue;
    }

    public void write() throws YException {
        OutputStreamWriter configWriter = null;
        int nEntries = this.configEntries.size();
        try {
            if (!this.hasChanged) {
                return;
            }
            configWriter = new FileWriter(this.configFile);
            for (int iEntry = 0; iEntry < nEntries; ++iEntry) {
                ConfigEntry configEntry = this.configEntries.get(iEntry);
                configWriter.write(configEntry.getName() + "=" + configEntry.getValue() + "\n");
            }
        }
        catch (IOException ex) {
            throw new YException("I/O-Fehler beim Schreiben der Konfigurationsdatei: " + ex.toString());
        }
        finally {
            try {
                if (configWriter != null) {
                    configWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private class ConfigEntry {
        private String name;
        private String value;

        ConfigEntry(String name, String value) {
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }

        void setValue(String value) {
            this.value = value;
        }
    }
}

