/*
 * Decompiled with CFR 0.152.
 */
package projektY.html;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import projektY.base.YException;
import projektY.html.YHTMLParser;

public class YHTMLGenerator {
    private OutputStream output;
    private OutputStreamWriter writer;

    protected YHTMLGenerator(OutputStream output) {
        this.output = output;
        this.writer = new OutputStreamWriter(output);
    }

    protected YHTMLGenerator(String nameOutputFile) throws FileNotFoundException {
        this(new FileOutputStream(new File(nameOutputFile)));
    }

    final OutputStream getOutputStream() {
        return this.output;
    }

    public void writeAsHTML(String text) throws YException {
        char[] chars = text.toCharArray();
        int l = chars.length;
        try {
            block17: for (int i = 0; i < l; ++i) {
                char c = chars[i];
                switch (chars[i]) {
                    case '\u00e4': {
                        this.writer.write("&auml;");
                        continue block17;
                    }
                    case '\u00f6': {
                        this.writer.write("&ouml;");
                        continue block17;
                    }
                    case '\u00fc': {
                        this.writer.write("&uuml;");
                        continue block17;
                    }
                    case '\u00c4': {
                        this.writer.write("&Auml;");
                        continue block17;
                    }
                    case '\u00d6': {
                        this.writer.write("&Ouml;");
                        continue block17;
                    }
                    case '\u00dc': {
                        this.writer.write("&Uuml;");
                        continue block17;
                    }
                    case '\u00df': {
                        this.writer.write("&szlig;");
                        continue block17;
                    }
                    case '\u20ac': {
                        this.writer.write("&euro;");
                        continue block17;
                    }
                    case '<': {
                        this.writer.write("&lt;");
                        continue block17;
                    }
                    case '>': {
                        this.writer.write("&gt;");
                        continue block17;
                    }
                    case '&': {
                        this.writer.write("&amp;");
                        continue block17;
                    }
                    case '\u00b5': {
                        this.writer.write("&micro;");
                        continue block17;
                    }
                    case '\n': {
                        this.writer.write("<br/>");
                    }
                    default: {
                        this.writer.write(c);
                    }
                }
            }
            this.writer.flush();
        }
        catch (IOException e) {
            throw new YException("I/O-Fehler: " + e.toString());
        }
    }

    protected void insertText(YHTMLParser.YHTMLTagAttributes attributes) throws YException {
    }

    protected boolean startTable(YHTMLParser.YHTMLTagAttributes attributes) throws YException {
        return true;
    }

    protected void endTable() throws YException {
    }

    protected boolean startTH(YHTMLParser.YHTMLTagAttributes attributes) throws YException {
        return true;
    }

    protected void endTH() throws YException {
    }

    protected boolean nextRow(YHTMLParser.YHTMLTagAttributes attributes) throws YException {
        return false;
    }

    protected void insertTD(YHTMLParser.YHTMLTagAttributes attributes) throws YException {
    }

    protected boolean checkOption(YHTMLParser.YHTMLTagAttributes attributes) throws YException {
        return true;
    }

    protected boolean nextLoop(YHTMLParser.YHTMLTagAttributes attributes) throws YException {
        return false;
    }

    protected void handleTag(YHTMLParser.YHTMLTag tag) throws YException {
    }
}

