/*
 * Decompiled with CFR 0.152.
 */
package projektY.latex;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.latex.YLaTeXParser;

public class YLaTeXGenerator {
    private OutputStream output;
    private OutputStreamWriter writer;
    YLaTeXParser.YLaTeXTag runTag;

    protected YLaTeXGenerator(OutputStream output) {
        this.output = output;
        this.writer = new OutputStreamWriter(output);
        this.runTag = null;
    }

    protected YLaTeXGenerator(String nameOutputFile) throws FileNotFoundException {
        this(new FileOutputStream(new File(nameOutputFile)));
    }

    final OutputStream getOutputStream() {
        return this.output;
    }

    protected void writePlain(String text) throws YException {
        try {
            this.writer.write(text);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new YException("I/O-Fehler: " + e.toString());
        }
    }

    public void writeAsLaTeX(String text) throws YException {
        char[] chars = text.toCharArray();
        int l = chars.length;
        try {
            block30: for (int i = 0; i < l; ++i) {
                char c = chars[i];
                switch (chars[i]) {
                    case '\u00e4': {
                        this.writer.write("\"a");
                        continue block30;
                    }
                    case '\u00f6': {
                        this.writer.write("\"o");
                        continue block30;
                    }
                    case '\u00fc': {
                        this.writer.write("\"u");
                        continue block30;
                    }
                    case '\u00c4': {
                        this.writer.write("\"A");
                        continue block30;
                    }
                    case '\u00d6': {
                        this.writer.write("\"O");
                        continue block30;
                    }
                    case '\u00dc': {
                        this.writer.write("\"U");
                        continue block30;
                    }
                    case '\u00df': {
                        this.writer.write("\"s");
                        continue block30;
                    }
                    case '\u20ac': {
                        this.writer.write("\\texteuro{}");
                        continue block30;
                    }
                    case '\\': {
                        this.writer.write("\\textbackslash{}");
                        continue block30;
                    }
                    case '{': {
                        this.writer.write("\\{");
                        continue block30;
                    }
                    case '}': {
                        this.writer.write("\\}");
                        continue block30;
                    }
                    case '~': {
                        this.writer.write("\\~");
                        continue block30;
                    }
                    case '&': {
                        this.writer.write("\\&");
                        continue block30;
                    }
                    case '#': {
                        this.writer.write("\\#");
                        continue block30;
                    }
                    case '%': {
                        this.writer.write("\\%");
                        continue block30;
                    }
                    case '$': {
                        this.writer.write("\\$");
                        continue block30;
                    }
                    case '_': {
                        this.writer.write("\\_");
                        continue block30;
                    }
                    case '\u00b2': {
                        this.writer.write("\\textsuperscript{2}");
                        continue block30;
                    }
                    case '\u00b3': {
                        this.writer.write("\\textsuperscript{3}");
                        continue block30;
                    }
                    case '>': {
                        this.writer.write("\\textgreater{}");
                        continue block30;
                    }
                    case '<': {
                        this.writer.write("\\textless{}");
                        continue block30;
                    }
                    case '\u00b0': {
                        this.writer.write("\\textdegree{}");
                        continue block30;
                    }
                    case '\u00ae': {
                        this.writer.write("\\textregistered{}");
                        continue block30;
                    }
                    case '\u00b5': {
                        this.writer.write("\\mu{}");
                        continue block30;
                    }
                    case '\t': {
                        this.writer.write(" ");
                        continue block30;
                    }
                    case '\n': {
                        this.writer.write("\\newline\n");
                        continue block30;
                    }
                    default: {
                        if (c >= ' ' && c < '~') {
                            this.writer.write(c);
                            continue block30;
                        }
                        this.writer.write("?");
                    }
                }
            }
            this.writer.flush();
        }
        catch (IOException e) {
            throw new YException("I/O-Fehler: " + e.toString());
        }
    }

    protected void init() throws YException {
    }

    protected void insertText(YLaTeXParser.YLaTeXTagAttributes attributes) throws YException {
    }

    protected boolean startTable(YLaTeXParser.YLaTeXTagAttributes attributes) throws YException {
        return true;
    }

    protected void endTable() throws YException {
    }

    protected boolean startTH(YLaTeXParser.YLaTeXTagAttributes attributes) throws YException {
        return true;
    }

    protected void endTH() throws YException {
    }

    protected boolean nextRow(YLaTeXParser.YLaTeXTagAttributes attributes) throws YException {
        return false;
    }

    protected void insertTD(YLaTeXParser.YLaTeXTagAttributes attributes) throws YException {
    }

    protected boolean checkOption(YLaTeXParser.YLaTeXTagAttributes attributes) throws YException {
        return true;
    }

    protected boolean nextLoop(YLaTeXParser.YLaTeXTagAttributes attributes) throws YException {
        return false;
    }

    protected void handleTag(YLaTeXParser.YLaTeXTag tag) throws YException {
    }

    protected final YLaTeXParser.YLaTeXTag getRunTag() throws YException {
        if (this.runTag == null) {
            throw new YProgramException(this, "Aufruf von getRunTag() au\u00dferhalb der Methode run().");
        }
        return this.runTag;
    }
}

