/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import projektY.base.YException;
import projektY.database.YDatabase;

public class YSQLQuery {
    protected YDatabase database;
    protected Statement stmt;
    protected ResultSet result;

    public YSQLQuery(YDatabase database) {
        this.database = database;
    }

    private void checkResult() throws YException {
        if (this.result == null) {
            throw new YException("Es ist kein Abfrageergebnis vorhanden.");
        }
    }

    public void execute(String sqlSelect) throws YException {
        try {
            if (this.database.ensureConnection(this.stmt == null ? null : this.stmt.getConnection())) {
                this.stmt = null;
            }
            if (this.database.sqlLog) {
                System.out.println(sqlSelect + ";");
            }
            if (this.stmt == null) {
                this.stmt = this.database.getConnection().createStatement();
            }
            this.result = this.stmt.executeQuery(sqlSelect);
        }
        catch (SQLException e) {
            int i;
            if (sqlSelect.length() > 80 && (i = sqlSelect.indexOf("FROM")) > 0) {
                String sqlSELECT = sqlSelect.substring(0, i - 1);
                String sqlFROM = sqlSelect.substring(i);
                if ((i = sqlFROM.indexOf("WHERE")) > 0) {
                    throw new YException("SQL-Fehler " + e.getSQLState() + ":\n" + sqlSELECT + "\n" + sqlFROM.substring(0, i - 1) + "\n" + sqlFROM.substring(i) + "\n" + e.getMessage());
                }
                throw new YException("SQL-Fehler " + e.getSQLState() + ":\n" + sqlSELECT + "\n" + sqlFROM + "\n" + e.getMessage());
            }
            throw new YException("SQL-Fehler " + e.getSQLState() + ":\n" + sqlSelect + "\n" + e.getMessage());
        }
    }

    public void close() throws YException {
        try {
            if (this.result != null) {
                this.result.close();
            }
        }
        catch (SQLException e) {
            throw new YException("SQL-Fehler:\n" + e.getMessage());
        }
    }

    public boolean next() throws YException {
        try {
            this.checkResult();
            return this.result.next();
        }
        catch (SQLException e) {
            throw new YException(e.getMessage());
        }
    }

    public String getString(String columnName) throws YException {
        try {
            this.checkResult();
            return this.result.getString(columnName);
        }
        catch (SQLException e) {
            throw new YException(e.getMessage());
        }
    }

    public long getLong(String columnName) throws YException {
        try {
            this.checkResult();
            return this.result.getLong(columnName);
        }
        catch (SQLException e) {
            throw new YException(e.getMessage());
        }
    }

    public short getShort(String columnName) throws YException {
        try {
            this.checkResult();
            return this.result.getShort(columnName);
        }
        catch (SQLException e) {
            throw new YException(e.getMessage());
        }
    }

    public int getInt(String columnName) throws YException {
        try {
            this.checkResult();
            return this.result.getInt(columnName);
        }
        catch (SQLException e) {
            throw new YException(e.getMessage());
        }
    }

    public Date getDate(String columnName) throws YException {
        try {
            this.checkResult();
            return this.result.getDate(columnName, (Calendar)this.database.getCal());
        }
        catch (SQLException e) {
            throw new YException(e.getMessage());
        }
    }

    public Time getTime(String columnName) throws YException {
        try {
            this.checkResult();
            return this.result.getTime(columnName, (Calendar)this.database.getCal());
        }
        catch (SQLException e) {
            throw new YException(e.getMessage());
        }
    }

    public Timestamp getTimestamp(String columnName) throws YException {
        try {
            this.checkResult();
            return this.result.getTimestamp(columnName, (Calendar)this.database.getCal());
        }
        catch (SQLException e) {
            throw new YException(e.getMessage());
        }
    }

    public boolean getBoolean(String columnName) throws YException {
        try {
            this.checkResult();
            return this.result.getBoolean(columnName);
        }
        catch (SQLException e) {
            throw new YException(e.getMessage());
        }
    }

    public float getFloat(String columnName) throws YException {
        try {
            this.checkResult();
            return this.result.getFloat(columnName);
        }
        catch (SQLException e) {
            throw new YException(e.getMessage());
        }
    }

    public double getDouble(String columnName) throws YException {
        try {
            this.checkResult();
            return this.result.getDouble(columnName);
        }
        catch (SQLException e) {
            throw new YException(e.getMessage());
        }
    }

    public boolean wasNull() throws YException {
        try {
            this.checkResult();
            return this.result.wasNull();
        }
        catch (SQLException e) {
            throw new YException(e.getMessage());
        }
    }
}

